/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.DataTableLocalIndexRegionScanner;
import org.apache.hadoop.hbase.regionserver.IndexHalfStoreFileReader;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.RepairUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHalfStoreFileReaderGenerator
extends BaseRegionObserver {
    private static final String LOCAL_INDEX_AUTOMATIC_REPAIR = "local.index.automatic.repair";
    public static final Logger LOGGER = LoggerFactory.getLogger(IndexHalfStoreFileReaderGenerator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StoreFile.Reader preStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFile.Reader reader) throws IOException {
        Object splitRow;
        PhoenixConnection conn;
        byte[] regionStartKeyInHFile;
        byte[] splitKey;
        HRegionInfo childRegion;
        Region region;
        block36: {
            TableName tableName = ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getRegion().getTableDesc().getTableName();
            region = ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getRegion();
            childRegion = region.getRegionInfo();
            splitKey = null;
            if (reader != null) return reader;
            if (r == null) return reader;
            if (!p.toString().contains("L#")) {
                return super.preStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, reader);
            }
            Scan scan = MetaTableAccessor.getScanForTableName((TableName)tableName);
            SingleColumnValueFilter scvf = null;
            if (Reference.isTopFileRegion((Reference.Range)r.getFileRegion())) {
                scvf = new SingleColumnValueFilter(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, CompareFilter.CompareOp.EQUAL, region.getRegionInfo().toByteArray());
                scvf.setFilterIfMissing(true);
            } else {
                scvf = new SingleColumnValueFilter(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, CompareFilter.CompareOp.EQUAL, region.getRegionInfo().toByteArray());
                scvf.setFilterIfMissing(true);
            }
            if (scvf != null) {
                scan.setFilter((Filter)scvf);
            }
            regionStartKeyInHFile = null;
            conn = null;
            try (HTable metaTable = null;){
                metaTable = new HTable(((RegionCoprocessorEnvironment)ctx.getEnvironment()).getConfiguration(), TableName.META_TABLE_NAME);
                Result result = null;
                try (ResultScanner scanner = null;){
                    scanner = metaTable.getScanner(scan);
                    result = scanner.next();
                }
                if (result == null || result.isEmpty()) {
                    block35: {
                        Pair mergeRegions = MetaTableAccessor.getRegionsFromMergeQualifier((Connection)((RegionCoprocessorEnvironment)ctx.getEnvironment()).getRegionServerServices().getConnection(), (byte[])region.getRegionInfo().getRegionName());
                        if (mergeRegions == null || mergeRegions.getFirst() == null) {
                            StoreFile.Reader reader2 = reader;
                            return reader2;
                        }
                        splitRow = CellUtil.cloneRow((Cell)KeyValue.createKeyValueFromKey((byte[])r.getSplitKey()));
                        if (Bytes.compareTo((byte[])((HRegionInfo)mergeRegions.getFirst()).getStartKey(), (byte[])splitRow) == 0) {
                            if (((HRegionInfo)mergeRegions.getFirst()).getStartKey().length == 0 && region.getRegionInfo().getEndKey().length != ((HRegionInfo)mergeRegions.getFirst()).getEndKey().length) {
                                childRegion = (HRegionInfo)mergeRegions.getFirst();
                                regionStartKeyInHFile = ((HRegionInfo)mergeRegions.getFirst()).getStartKey().length == 0 ? new byte[((HRegionInfo)mergeRegions.getFirst()).getEndKey().length] : ((HRegionInfo)mergeRegions.getFirst()).getStartKey();
                                break block35;
                            } else {
                                StoreFile.Reader reader3 = reader;
                                return reader3;
                            }
                        }
                        childRegion = (HRegionInfo)mergeRegions.getSecond();
                        regionStartKeyInHFile = ((HRegionInfo)mergeRegions.getSecond()).getStartKey();
                    }
                    splitKey = KeyValue.createFirstOnRow((byte[])(region.getRegionInfo().getStartKey().length == 0 ? new byte[region.getRegionInfo().getEndKey().length] : region.getRegionInfo().getStartKey())).getKey();
                    break block36;
                }
                HRegionInfo parentRegion = HRegionInfo.getHRegionInfo((Result)result);
                regionStartKeyInHFile = parentRegion.getStartKey().length == 0 ? new byte[parentRegion.getEndKey().length] : parentRegion.getStartKey();
            }
        }
        try {
            conn = QueryUtil.getConnectionOnServer(((RegionCoprocessorEnvironment)ctx.getEnvironment()).getConfiguration()).unwrap(PhoenixConnection.class);
            PTable dataTable = IndexUtil.getPDataTable(conn, ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getRegion().getTableDesc());
            List<PTable> indexes = dataTable.getIndexes();
            HashMap<ImmutableBytesWritable, IndexMaintainer> indexMaintainers = new HashMap<ImmutableBytesWritable, IndexMaintainer>();
            splitRow = indexes.iterator();
            while (splitRow.hasNext()) {
                PTable index = (PTable)splitRow.next();
                if (index.getIndexType() != PTable.IndexType.LOCAL) continue;
                IndexMaintainer indexMaintainer = index.getIndexMaintainer(dataTable, conn);
                indexMaintainers.put(new ImmutableBytesWritable(index.getviewIndexIdType().toBytes(index.getViewIndexId())), indexMaintainer);
            }
            if (indexMaintainers.isEmpty()) {
                splitRow = reader;
                return splitRow;
            }
            byte[][] viewConstants = this.getViewConstants(dataTable);
            IndexHalfStoreFileReader indexHalfStoreFileReader = new IndexHalfStoreFileReader(fs, p, cacheConf, in, size, r, ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getConfiguration(), indexMaintainers, viewConstants, childRegion, regionStartKeyInHFile, splitKey, region.getRegionInfo());
            return indexHalfStoreFileReader;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner s, ScanType scanType, CompactionRequest request) throws IOException {
        if (!IndexUtil.isLocalIndexStore(store)) {
            return s;
        }
        if (!store.hasReferences()) {
            InternalScanner repairScanner = null;
            if (request.isMajor() && !RepairUtil.isLocalIndexStoreFilesConsistent((RegionCoprocessorEnvironment)c.getEnvironment(), store)) {
                LOGGER.info("we have found inconsistent data for local index for region:" + ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo());
                if (((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration().getBoolean(LOCAL_INDEX_AUTOMATIC_REPAIR, true)) {
                    LOGGER.info("Starting automatic repair of local Index for region:" + ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo());
                    repairScanner = this.getRepairScanner((RegionCoprocessorEnvironment)c.getEnvironment(), store);
                }
            }
            if (repairScanner != null) {
                if (s != null) {
                    s.close();
                }
                return repairScanner;
            }
            return s;
        }
        return s;
    }

    private byte[][] getViewConstants(PTable dataTable) {
        int dataPosOffset = (dataTable.getBucketNum() != null ? 1 : 0) + (dataTable.isMultiTenant() ? 1 : 0);
        Object viewConstants = null;
        int nViewConstants = 0;
        if (dataTable.getType() == PTableType.VIEW) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            List<PColumn> dataPkColumns = dataTable.getPKColumns();
            for (int i = dataPosOffset; i < dataPkColumns.size(); ++i) {
                PColumn dataPKColumn = dataPkColumns.get(i);
                if (dataPKColumn.getViewConstant() == null) continue;
                ++nViewConstants;
            }
            if (nViewConstants > 0) {
                viewConstants = new byte[nViewConstants][];
                int j = 0;
                for (int i = dataPosOffset; i < dataPkColumns.size(); ++i) {
                    PColumn dataPkColumn = dataPkColumns.get(i);
                    if (dataPkColumn.getViewConstant() == null) continue;
                    if (IndexUtil.getViewConstantValue(dataPkColumn, ptr)) {
                        viewConstants[j++] = ByteUtil.copyKeyBytesIfNecessary(ptr);
                        continue;
                    }
                    throw new IllegalStateException();
                }
            }
        }
        return viewConstants;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InternalScanner getRepairScanner(RegionCoprocessorEnvironment env, Store store) throws IOException {
        Scan scan = new Scan();
        scan.setMaxVersions(store.getFamily().getMaxVersions());
        for (Store s : env.getRegion().getStores()) {
            if (IndexUtil.isLocalIndexStore(s)) continue;
            scan.addFamily(s.getFamily().getName());
        }
        try (PhoenixConnection conn = QueryUtil.getConnectionOnServer(env.getConfiguration()).unwrap(PhoenixConnection.class);){
            PTable dataPTable = IndexUtil.getPDataTable(conn, env.getRegion().getTableDesc());
            ArrayList maintainers = Lists.newArrayListWithExpectedSize((int)dataPTable.getIndexes().size());
            for (PTable index : dataPTable.getIndexes()) {
                if (index.getIndexType() != PTable.IndexType.LOCAL) continue;
                maintainers.add(index.getIndexMaintainer(dataPTable, conn));
            }
            DataTableLocalIndexRegionScanner dataTableLocalIndexRegionScanner = new DataTableLocalIndexRegionScanner(env.getRegion().getScanner(scan), env.getRegion(), maintainers, store.getFamily().getName(), env.getConfiguration());
            return dataTableLocalIndexRegionScanner;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

