/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.CompoundParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;

public class BetweenParseNode
extends CompoundParseNode {
    private final boolean negate;

    BetweenParseNode(ParseNode l, ParseNode r1, ParseNode r2, boolean negate) {
        super(Arrays.asList(l, r1, r2));
        this.negate = negate;
    }

    public boolean isNegate() {
        return this.negate;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        List l = Collections.emptyList();
        if (visitor.visitEnter(this)) {
            l = this.acceptChildren(visitor);
        }
        return visitor.visitLeave(this, l);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.negate ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BetweenParseNode other = (BetweenParseNode)obj;
        return this.negate == other.negate;
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        List<ParseNode> children = this.getChildren();
        children.get(0).toSQL(resolver, buf);
        if (this.negate) {
            buf.append(" NOT");
        }
        buf.append(" BETWEEN ");
        children.get(1).toSQL(resolver, buf);
        buf.append(" AND ");
        children.get(2).toSQL(resolver, buf);
    }
}

