/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.execute.CursorFetchPlan;
import org.apache.phoenix.iterate.CursorResultIterator;
import org.apache.phoenix.parse.CloseStatement;
import org.apache.phoenix.parse.DeclareCursorStatement;
import org.apache.phoenix.parse.OpenStatement;
import org.apache.phoenix.schema.tuple.Tuple;

public final class CursorUtil {
    private static Map<String, CursorWrapper> mapCursorIDQuery = new HashMap<String, CursorWrapper>();

    private CursorUtil() {
    }

    public static boolean declareCursor(DeclareCursorStatement stmt, QueryPlan queryPlan) throws SQLException {
        if (mapCursorIDQuery.containsKey(stmt.getCursorName())) {
            throw new SQLException("Can't declare cursor " + stmt.getCursorName() + ", cursor identifier already in use.");
        }
        mapCursorIDQuery.put(stmt.getCursorName(), new CursorWrapper(stmt.getCursorName(), stmt.getQuerySQL(), queryPlan));
        return true;
    }

    public static boolean openCursor(OpenStatement stmt, Connection conn) throws SQLException {
        if (mapCursorIDQuery.containsKey(stmt.getCursorName())) {
            CursorUtil.mapCursorIDQuery.get(stmt.getCursorName()).openCursor(conn);
            return true;
        }
        throw new SQLException("Cursor " + stmt.getCursorName() + " not declared.");
    }

    public static void closeCursor(CloseStatement stmt) throws SQLException {
        if (mapCursorIDQuery.containsKey(stmt.getCursorName())) {
            CursorUtil.mapCursorIDQuery.get(stmt.getCursorName()).closeCursor();
        }
    }

    public static QueryPlan getFetchPlan(String cursorName, boolean isNext, int fetchSize) throws SQLException {
        if (mapCursorIDQuery.containsKey(cursorName)) {
            return CursorUtil.mapCursorIDQuery.get(cursorName).getFetchPlan(isNext, fetchSize);
        }
        throw new SQLException("Cursor " + cursorName + " not declared.");
    }

    public static String getFetchSQL(String cursorName) throws SQLException {
        if (mapCursorIDQuery.containsKey(cursorName)) {
            return mapCursorIDQuery.get(cursorName).getFetchSQL();
        }
        throw new SQLException("Cursor " + cursorName + " not declared.");
    }

    public static void updateCursor(String cursorName, Tuple rowValues, Tuple nextRowValues) throws SQLException {
        mapCursorIDQuery.get(cursorName).updateLastScanRow(rowValues, nextRowValues);
    }

    public static boolean cursorDeclared(String cursorName) {
        return mapCursorIDQuery.containsKey(cursorName);
    }

    public static boolean moreValues(String cursorName) {
        return mapCursorIDQuery.get(cursorName).moreValues();
    }

    private static class CursorWrapper {
        private final String cursorName;
        private final String selectSQL;
        private boolean isOpen = false;
        QueryPlan queryPlan;
        ImmutableBytesWritable row;
        ImmutableBytesWritable previousRow;
        private Scan scan;
        private boolean moreValues = true;
        private boolean isReversed;
        private boolean islastCallNext;
        private CursorFetchPlan fetchPlan;
        private int offset = -1;
        private boolean isAggregate;

        private CursorWrapper(String cursorName, String selectSQL, QueryPlan queryPlan) {
            this.cursorName = cursorName;
            this.selectSQL = selectSQL;
            this.queryPlan = queryPlan;
            this.islastCallNext = true;
            this.fetchPlan = new CursorFetchPlan(queryPlan, cursorName);
            this.isAggregate = this.fetchPlan.isAggregate();
        }

        private synchronized void openCursor(Connection conn) throws SQLException {
            if (this.isOpen) {
                return;
            }
            this.scan = this.queryPlan.getContext().getScan();
            this.isReversed = OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY.equals(this.queryPlan.getOrderBy());
            this.isOpen = true;
        }

        private void closeCursor() throws SQLException {
            this.isOpen = false;
            ((CursorResultIterator)this.fetchPlan.iterator()).closeCursor();
            mapCursorIDQuery.remove(this.cursorName);
        }

        private QueryPlan getFetchPlan(boolean isNext, int fetchSize) throws SQLException {
            if (!this.isOpen) {
                throw new SQLException("Fetch call on closed cursor '" + this.cursorName + "'!");
            }
            ((CursorResultIterator)this.fetchPlan.iterator()).setFetchSize(fetchSize);
            if (!this.isAggregate && this.row != null) {
                this.scan.setStartRow(this.row.get());
            }
            return this.fetchPlan;
        }

        public void updateLastScanRow(Tuple rowValues, Tuple nextRowValues) {
            boolean bl = !this.isReversed ? nextRowValues != null : (this.moreValues = rowValues != null);
            if (!this.moreValues()) {
                return;
            }
            if (this.row == null) {
                this.row = new ImmutableBytesWritable();
            }
            if (this.previousRow == null) {
                this.previousRow = new ImmutableBytesWritable();
            }
            if (nextRowValues != null) {
                nextRowValues.getKey(this.row);
            }
            if (rowValues != null) {
                rowValues.getKey(this.previousRow);
            }
            ++this.offset;
        }

        public boolean moreValues() {
            return this.moreValues;
        }

        public String getFetchSQL() throws SQLException {
            if (!this.isOpen) {
                throw new SQLException("Fetch call on closed cursor '" + this.cursorName + "'!");
            }
            return this.selectSQL;
        }
    }
}

