/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.io.IOUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.TestingServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestUtils.class);
    private static final int DEFAULT_ZK_PORT = 2181;

    public static int getFreeLocalPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            socket.setReuseAddress(true);
            int n = socket.getLocalPort();
            return n;
        }
    }

    public static TestingServer provideTestingZKServer(int port) throws Exception {
        return new TestingServer(port);
    }

    public static TestingServer provideTestingZKServer() throws Exception {
        return TestUtils.provideTestingZKServer(2181);
    }

    public static CuratorFramework provideConnectedZKClient(String zkCluster) throws Exception {
        LOG.info("Creating Zookeeper Client connecting to {}", (Object)zkCluster);
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFramework zkClient = CuratorFrameworkFactory.builder().namespace("omid").connectString(zkCluster).retryPolicy((RetryPolicy)retryPolicy).build();
        LOG.info("Connecting to ZK cluster {}", (Object)zkClient.getState());
        zkClient.start();
        zkClient.blockUntilConnected();
        LOG.info("Connection to ZK cluster {}", (Object)zkClient.getState());
        return zkClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForSocketListening(String host, int port, int sleepTimeMillis) throws IOException, InterruptedException {
        Socket sock;
        while (true) {
            sock = null;
            try {
                sock = new Socket(host, port);
            }
            catch (IOException e) {
                try {
                    Thread.sleep(sleepTimeMillis);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(sock);
                    throw throwable;
                }
                IOUtils.closeQuietly((Socket)sock);
                continue;
            }
            break;
        }
        IOUtils.closeQuietly((Socket)sock);
        LOG.info("Host " + host + ":" + port + " is up...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void waitForSocketNotListening(String host, int port, int sleepTimeMillis) throws IOException, InterruptedException {
        while (true) {
            Socket sock = null;
            try {
                sock = new Socket(host, port);
            }
            catch (IOException e) {
                IOUtils.closeQuietly(sock);
                break;
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(sock);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Socket)sock);
            Thread.sleep(sleepTimeMillis);
            LOG.info("Host " + host + ":" + port + " is still up...");
        }
    }
}

