/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.DateScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PTimestamp;

@FunctionParseNode.BuiltInFunction(name="HOUR", args={@FunctionParseNode.Argument(allowedTypes={PTimestamp.class})})
public class HourFunction
extends DateScalarFunction {
    public static final String NAME = "HOUR";

    public HourFunction() {
    }

    public HourFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression expression = this.getChildExpression();
        if (!expression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        long dateTime = this.inputCodec.decodeLong(ptr, expression.getSortOrder());
        int hour = (int)(dateTime / 1000L % 86400L / 3600L);
        PDataType returnType = this.getDataType();
        byte[] byteValue = new byte[returnType.getByteSize().intValue()];
        returnType.getCodec().encodeInt(hour, byteValue, 0);
        ptr.set(byteValue);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PInteger.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private Expression getChildExpression() {
        return (Expression)this.children.get(0);
    }
}

