/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class HostAndPort
implements Serializable {
    private static final int NO_PORT = -1;
    private final String host;
    private final int port;
    private final boolean hasBracketlessColons;
    private static final Pattern BRACKET_PATTERN = Pattern.compile("^\\[(.*:.*)\\](?::(\\d*))?$");
    private static final long serialVersionUID = 0L;

    private HostAndPort(String host, int port, boolean hasBracketlessColons) {
        this.host = host;
        this.port = port;
        this.hasBracketlessColons = hasBracketlessColons;
    }

    public String getHostText() {
        return this.host;
    }

    public boolean hasPort() {
        return this.port >= 0;
    }

    public int getPort() {
        if (!this.hasPort()) {
            throw new IllegalStateException();
        }
        return this.port;
    }

    public int getPortOrDefault(int defaultPort) {
        return this.hasPort() ? this.port : defaultPort;
    }

    public static HostAndPort fromParts(String host, int port) {
        if (!HostAndPort.isValidPort(port)) {
            throw new IllegalArgumentException();
        }
        HostAndPort parsedHost = HostAndPort.fromString(host);
        if (parsedHost.hasPort()) {
            throw new IllegalArgumentException();
        }
        return new HostAndPort(parsedHost.host, port, parsedHost.hasBracketlessColons);
    }

    public static HostAndPort fromString(String hostPortString) {
        String host;
        if (hostPortString == null) {
            throw new NullPointerException();
        }
        String portString = null;
        boolean hasBracketlessColons = false;
        if (hostPortString.startsWith("[")) {
            Matcher matcher = BRACKET_PATTERN.matcher(hostPortString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("Invalid bracketed host/port: %s", hostPortString));
            }
            host = matcher.group(1);
            portString = matcher.group(2);
        } else {
            int colonPos = hostPortString.indexOf(58);
            if (colonPos >= 0 && hostPortString.indexOf(58, colonPos + 1) == -1) {
                host = hostPortString.substring(0, colonPos);
                portString = hostPortString.substring(colonPos + 1);
            } else {
                host = hostPortString;
                hasBracketlessColons = colonPos >= 0;
            }
        }
        int port = -1;
        if (portString != null) {
            if (portString.startsWith("+")) {
                throw new IllegalArgumentException(String.format("Unparseable port number: %s", hostPortString));
            }
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unparseable port number: " + hostPortString);
            }
            if (!HostAndPort.isValidPort(port)) {
                throw new IllegalArgumentException(String.format("Port number out of range: %s", hostPortString));
            }
        }
        return new HostAndPort(host, port, hasBracketlessColons);
    }

    public HostAndPort withDefaultPort(int defaultPort) {
        if (!HostAndPort.isValidPort(defaultPort)) {
            throw new IllegalArgumentException();
        }
        if (this.hasPort() || this.port == defaultPort) {
            return this;
        }
        return new HostAndPort(this.host, defaultPort, this.hasBracketlessColons);
    }

    public HostAndPort requireBracketsForIPv6() {
        if (this.hasBracketlessColons) {
            throw new IllegalArgumentException(String.format("Possible bracketless IPv6 literal: %s", this.host));
        }
        return this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HostAndPort) {
            HostAndPort that = (HostAndPort)other;
            return Objects.equals(this.host, that.host) && this.port == that.port && this.hasBracketlessColons == that.hasBracketlessColons;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.hasBracketlessColons);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.host.length() + 7);
        if (this.host.indexOf(58) >= 0) {
            builder.append('[').append(this.host).append(']');
        } else {
            builder.append(this.host);
        }
        if (this.hasPort()) {
            builder.append(':').append(this.port);
        }
        return builder.toString();
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }
}

