/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigStatsOutputSizeReader;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.impl.util.UriUtil;

public class FileBasedOutputSizeReader
implements PigStatsOutputSizeReader {
    private static final Log log = LogFactory.getLog(FileBasedOutputSizeReader.class);

    @Override
    public boolean supports(POStore sto, Configuration conf) {
        String unsupported;
        boolean nullOrSupportedScheme = UriUtil.isHDFSFileOrLocalOrS3N(FileBasedOutputSizeReader.getLocationUri(sto), conf);
        if (nullOrSupportedScheme && (unsupported = conf.get("pig.stats.output.size.reader.unsupported")) != null) {
            String storeFuncName = sto.getStoreFunc().getClass().getCanonicalName();
            for (String s : unsupported.split(",")) {
                if (!s.equalsIgnoreCase(storeFuncName)) continue;
                return false;
            }
        }
        return nullOrSupportedScheme;
    }

    @Override
    public long getOutputSize(POStore sto, Configuration conf) throws IOException {
        if (!this.supports(sto, conf)) {
            log.warn((Object)("'" + sto.getStoreFunc().getClass().getCanonicalName() + "' is not supported by " + this.getClass().getCanonicalName()));
            return -1L;
        }
        Path p = new Path(FileBasedOutputSizeReader.getLocationUri(sto));
        return this.getPathSize(p, p.getFileSystem(conf));
    }

    private long getPathSize(Path storePath, FileSystem fs) throws IOException {
        long bytes = 0L;
        FileStatus[] lst = fs.listStatus(storePath);
        if (lst != null) {
            for (FileStatus status : lst) {
                if (status.isFile()) {
                    if (status.getLen() <= 0L) continue;
                    bytes += status.getLen();
                    continue;
                }
                bytes += this.getPathSize(status.getPath(), fs);
            }
        }
        return bytes;
    }

    private static String getLocationUri(POStore sto) {
        return sto.getSFile().getFileName();
    }
}

