/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.IteratorTransform;

abstract class CachedIteratorTransform<IN, OUT>
extends IteratorTransform<IN, OUT> {
    private OUT cachedObject = null;
    private boolean isCached = false;
    private boolean endReached = false;

    public CachedIteratorTransform(Iterator<IN> delegate) {
        super(delegate);
    }

    @Override
    public boolean hasNext() {
        if (this.endReached) {
            return false;
        }
        if (!this.isCached) {
            try {
                this.cachedObject = this.transform(this.delegate.next());
                this.isCached = true;
            }
            catch (NoSuchElementException ex) {
                this.cachedObject = null;
                this.isCached = false;
                this.endReached = true;
                return false;
            }
        }
        return true;
    }

    @Override
    public OUT next() {
        if (!this.isCached) {
            return this.transform(this.delegate.next());
        }
        OUT retObject = this.cachedObject;
        this.cachedObject = null;
        this.isCached = false;
        return retObject;
    }
}

