/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezOutput;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezTaskConfigurable;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueWriter;

public class POValueOutputTez
extends PhysicalOperator
implements TezOutput,
TezTaskConfigurable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(POValueOutputTez.class);
    private boolean scalarOutput;
    private transient Object scalarValue;
    private boolean taskIndexWithRecordIndexAsKey;
    private Set<String> outputKeys = new HashSet<String>();
    private transient List<KeyValueWriter> writers;
    private transient Object key;
    private transient int taskIndex;
    private transient long count;
    public static EmptyWritable EMPTY_KEY = new EmptyWritable();

    public POValueOutputTez(OperatorKey k) {
        super(k);
    }

    public boolean isScalarOutput() {
        return this.scalarOutput;
    }

    public void setScalarOutput(boolean scalarOutput) {
        this.scalarOutput = scalarOutput;
    }

    public boolean isTaskIndexWithRecordIndexAsKey() {
        return this.taskIndexWithRecordIndexAsKey;
    }

    public void setTaskIndexWithRecordIndexAsKey(boolean taskIndexWithRecordIndexAsKey) {
        this.taskIndexWithRecordIndexAsKey = taskIndexWithRecordIndexAsKey;
    }

    @Override
    public void initialize(ProcessorContext processorContext) throws ExecException {
        this.taskIndex = processorContext.getTaskIndex();
    }

    @Override
    public String[] getTezOutputs() {
        return this.outputKeys.toArray(new String[this.outputKeys.size()]);
    }

    @Override
    public void replaceOutput(String oldOutputKey, String newOutputKey) {
        while (this.outputKeys.remove(oldOutputKey)) {
            this.outputKeys.add(newOutputKey);
        }
    }

    @Override
    public void attachOutputs(Map<String, LogicalOutput> outputs, Configuration conf) throws ExecException {
        this.writers = new ArrayList<KeyValueWriter>();
        for (String outputKey : this.outputKeys) {
            LogicalOutput output = outputs.get(outputKey);
            if (output == null) {
                throw new ExecException("Output to vertex " + outputKey + " is missing");
            }
            try {
                KeyValueWriter writer = (KeyValueWriter)output.getWriter();
                this.writers.add(writer);
                LOG.info((Object)("Attached output to vertex " + outputKey + " : output=" + output + ", writer=" + writer));
            }
            catch (Exception e) {
                throw new ExecException(e);
            }
        }
        this.count = 0L;
        if (!this.taskIndexWithRecordIndexAsKey) {
            this.key = EMPTY_KEY;
        }
    }

    public void addOutputKey(String outputKey) {
        this.outputKeys.add(outputKey);
    }

    public void removeOutputKey(String outputKey) {
        this.outputKeys.remove(outputKey);
    }

    public boolean containsOutputKey(String outputKey) {
        return this.outputKeys.contains(outputKey);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        Result inp;
        block8: {
            do {
                inp = this.processInput();
                if (inp.returnStatus == 3 || inp.returnStatus == 2) break block8;
            } while (inp.returnStatus == 1);
            if (this.scalarOutput) {
                if (this.scalarValue == null) {
                    this.scalarValue = inp.result;
                } else {
                    String msg = "Scalar has more than one row in the output. 1st : " + this.scalarValue + ", 2nd :" + inp.result + " (common cause: \"JOIN\" then \"FOREACH ... GENERATE foo.bar\" should be \"foo::bar\" )";
                    throw new ExecException(msg);
                }
            }
            if (this.taskIndexWithRecordIndexAsKey) {
                Tuple tuple = mTupleFactory.newTuple(2);
                tuple.set(0, this.taskIndex);
                tuple.set(1, this.count++);
                this.key = tuple;
            }
            for (KeyValueWriter writer : this.writers) {
                try {
                    writer.write(this.key, inp.result);
                }
                catch (IOException e) {
                    throw new ExecException(e);
                }
            }
            return RESULT_EMPTY;
        }
        return inp;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visit(this);
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public String name() {
        ArrayList<String> outputKeyList = new ArrayList<String>(this.outputKeys);
        Collections.sort(outputKeyList);
        return "POValueOutputTez - " + this.mKey.toString() + "\t->\t " + outputKeyList;
    }

    public static class EmptyWritable
    implements Writable {
        public void write(DataOutput out) throws IOException {
        }

        public void readFields(DataInput in) throws IOException {
        }
    }
}

