/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.bloom;

import org.apache.hadoop.util.bloom.Key;
import org.apache.pig.impl.bloom.Hash;

public class HashFunction {
    protected int nbHash;
    protected int maxValue;
    protected Hash hashAlgorithm;

    public HashFunction(int maxValue, int nbHash, int hashAlgorithm) {
        if (maxValue <= 0) {
            throw new IllegalArgumentException("maxValue must be > 0");
        }
        if (nbHash <= 0) {
            throw new IllegalArgumentException("nbHash must be > 0");
        }
        this.maxValue = maxValue;
        this.nbHash = nbHash;
        this.hashAlgorithm = Hash.getInstance(hashAlgorithm);
    }

    public void clear() {
    }

    public int[] hash(Key k) {
        byte[] b = k.getBytes();
        if (b == null) {
            throw new NullPointerException("buffer reference is null");
        }
        if (b.length == 0) {
            throw new IllegalArgumentException("key length must be > 0");
        }
        return this.hashAlgorithm.hash(b, this.maxValue, this.nbHash);
    }
}

