/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.Iterator;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

public class NestedLimitOptimizer
extends Rule {
    public NestedLimitOptimizer(String name) {
        super(name, false);
    }

    @Override
    protected OperatorPlan buildPattern() {
        LogicalPlan plan = new LogicalPlan();
        LOForEach forEach = new LOForEach(plan);
        plan.add(forEach);
        return plan;
    }

    @Override
    public Transformer getNewTransformer() {
        return new OptimizeNestedLimitTransformer();
    }

    public class OptimizeNestedLimitTransformer
    extends Transformer {
        @Override
        public boolean check(OperatorPlan matched) {
            LOForEach forEach = (LOForEach)matched.getSources().get(0);
            LogicalPlan innerPlan = forEach.getInnerPlan();
            Iterator<Operator> it = innerPlan.getOperators();
            while (it.hasNext()) {
                Operator op = it.next();
                if (!(op instanceof LOLimit)) continue;
                List<Operator> preds = innerPlan.getPredecessors(op);
                LOLimit limitOp = (LOLimit)op;
                boolean useExpressionPlan = limitOp.getLimit() == -1L && limitOp.getLimitPlan() != null;
                if (useExpressionPlan || !(preds.get(0) instanceof LOSort)) continue;
                return true;
            }
            return false;
        }

        @Override
        public OperatorPlan reportChanges() {
            return NestedLimitOptimizer.this.currentPlan;
        }

        @Override
        public void transform(OperatorPlan matched) throws FrontendException {
            LOForEach forEach = (LOForEach)matched.getSources().get(0);
            LogicalPlan innerPlan = forEach.getInnerPlan();
            Iterator<Operator> it = innerPlan.getOperators();
            LOLimit limit = null;
            LOSort sort = null;
            while (it.hasNext()) {
                Operator op = it.next();
                if (!(op instanceof LOLimit)) continue;
                List<Operator> preds = innerPlan.getPredecessors(op);
                LOLimit limitOp = (LOLimit)op;
                boolean useExpressionPlan = limitOp.getLimit() == -1L && limitOp.getLimitPlan() != null;
                if (useExpressionPlan || !(preds.get(0) instanceof LOSort)) continue;
                limit = (LOLimit)op;
                sort = (LOSort)preds.get(0);
                break;
            }
            sort.setLimit(limit.getLimit());
            innerPlan.removeAndReconnect(limit);
        }
    }
}

