/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.replication;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.server.replication.WorkAssigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkDriver
extends Daemon {
    private static final Logger log = LoggerFactory.getLogger(WorkDriver.class);
    private Master master;
    private Connector conn;
    private AccumuloConfiguration conf;
    private WorkAssigner assigner;
    private String assignerImplName;

    public WorkDriver(Master master) throws AccumuloException, AccumuloSecurityException {
        this.master = master;
        this.conn = master.getConnector();
        this.conf = master.getConfiguration();
        this.configureWorkAssigner();
    }

    protected void configureWorkAssigner() {
        String workAssignerClass = this.conf.get(Property.REPLICATION_WORK_ASSIGNER);
        if (null == this.assigner || !this.assigner.getClass().getName().equals(workAssignerClass)) {
            log.info("Initializing work assigner implementation of {}", (Object)workAssignerClass);
            try {
                Class<?> clz = Class.forName(workAssignerClass);
                Class<WorkAssigner> workAssignerClz = clz.asSubclass(WorkAssigner.class);
                this.assigner = workAssignerClz.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.error("Could not instantiate configured work assigner {}", (Object)workAssignerClass, (Object)e);
                throw new RuntimeException(e);
            }
            this.assigner.configure(this.conf, this.conn);
            this.assignerImplName = this.assigner.getClass().getName();
            this.setName(this.assigner.getName());
        }
    }

    protected Connector getConnector() {
        return this.conn;
    }

    protected void setConnector(Connector conn) {
        this.conn = conn;
    }

    protected AccumuloConfiguration getConf() {
        return this.conf;
    }

    protected void setConf(AccumuloConfiguration conf) {
        this.conf = conf;
    }

    public void run() {
        log.info("Starting replication work assignment thread using {}", (Object)this.assignerImplName);
        while (this.master.stillMaster()) {
            try {
                this.assigner.assignWork();
            }
            catch (Exception e) {
                log.error("Error while assigning work", (Throwable)e);
            }
            long sleepTime = this.conf.getTimeInMillis(Property.REPLICATION_WORK_ASSIGNMENT_SLEEP);
            log.trace("Sleeping {} ms before next work assignment", (Object)sleepTime);
            UtilWaitThread.sleepUninterruptibly((long)sleepTime, (TimeUnit)TimeUnit.MILLISECONDS);
            this.configureWorkAssigner();
        }
    }
}

