/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.FinishCreateTable;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.TableInfo;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.ZooLock;

class PopulateMetadata
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private TableInfo tableInfo;

    PopulateMetadata(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        KeyExtent extent = new KeyExtent(this.tableInfo.tableId, null, null);
        MetadataTableUtil.addTablet((KeyExtent)extent, (String)this.tableInfo.dir, (ClientContext)environment, (char)this.tableInfo.timeType, (ZooLock)environment.getMasterLock());
        return new FinishCreateTable(this.tableInfo);
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        MetadataTableUtil.deleteTable((String)this.tableInfo.tableId, (boolean)false, (ClientContext)environment, (ZooLock)environment.getMasterLock());
    }
}

