/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparator;
import org.apache.pig.backend.hadoop.DateTimeWritable;
import org.apache.pig.impl.io.NullableDateTimeWritable;
import org.apache.pig.impl.util.ObjectSerializer;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class PigDateTimeRawComparator
extends WritableComparator
implements Configurable {
    private final Log mLog = LogFactory.getLog(((Object)((Object)this)).getClass());
    private boolean[] mAsc;
    private DateTimeWritable.Comparator mWrappedComp = new DateTimeWritable.Comparator();

    public PigDateTimeRawComparator() {
        super(NullableDateTimeWritable.class);
    }

    public void setConf(Configuration conf) {
        try {
            this.mAsc = (boolean[])ObjectSerializer.deserialize(conf.get("pig.sortOrder"));
        }
        catch (IOException ioe) {
            this.mLog.error((Object)("Unable to deserialize pig.sortOrder " + ioe.getMessage()));
            throw new RuntimeException(ioe);
        }
        if (this.mAsc == null) {
            this.mAsc = new boolean[1];
            this.mAsc[0] = true;
        }
    }

    public Configuration getConf() {
        return null;
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int rc = 0;
        rc = b1[s1] == 0 && b2[s2] == 0 ? this.mWrappedComp.compare(b1, s1 + 1, l1 - 2, b2, s2 + 1, l2 - 2) : (b1[s1] != 0 && b2[s2] != 0 ? b1[s1 + 1] - b2[s2 + 1] : (b1[s1] != 0 ? -1 : 1));
        if (!this.mAsc[0]) {
            rc *= -1;
        }
        return rc;
    }

    public int compare(Object o1, Object o2) {
        NullableDateTimeWritable ndtw1 = (NullableDateTimeWritable)o1;
        NullableDateTimeWritable ndtw2 = (NullableDateTimeWritable)o2;
        int rc = 0;
        rc = !ndtw1.isNull() && !ndtw2.isNull() ? ((DateTime)ndtw1.getValueAsPigType()).compareTo((ReadableInstant)((DateTime)ndtw2.getValueAsPigType())) : (ndtw1.isNull() && ndtw2.isNull() ? ndtw1.getIndex() - ndtw2.getIndex() : (ndtw1.isNull() ? -1 : 1));
        if (!this.mAsc[0]) {
            rc *= -1;
        }
        return rc;
    }
}

