/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.NoopFilterRemoverUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Pair;

class NoopFilterRemover
extends MROpPlanVisitor {
    private Log log = LogFactory.getLog(this.getClass());

    NoopFilterRemover(MROperPlan plan) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DependencyOrderWalker<MapReduceOper, MROperPlan>(plan));
    }

    @Override
    public void visitMROp(MapReduceOper mr) throws VisitorException {
        new PhysicalRemover(mr.mapPlan).visit();
        new PhysicalRemover(mr.combinePlan).visit();
        new PhysicalRemover(mr.reducePlan).visit();
    }

    private class PhysicalRemover
    extends PhyPlanVisitor {
        private List<Pair<POFilter, PhysicalPlan>> removalQ;

        PhysicalRemover(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DependencyOrderWalker<PhysicalOperator, PhysicalPlan>(plan));
            this.removalQ = new LinkedList<Pair<POFilter, PhysicalPlan>>();
        }

        @Override
        public void visit() throws VisitorException {
            super.visit();
            for (Pair<POFilter, PhysicalPlan> pair : this.removalQ) {
                NoopFilterRemoverUtil.removeFilter((POFilter)pair.first, (PhysicalPlan)pair.second);
            }
            this.removalQ.clear();
        }

        @Override
        public void visitFilter(POFilter fl) throws VisitorException {
            Boolean filterValue;
            ConstantExpression exp;
            Object value;
            PhysicalOperator op;
            PhysicalPlan filterPlan = fl.getPlan();
            if (filterPlan.size() == 1 && (op = (PhysicalOperator)filterPlan.getRoots().get(0)) instanceof ConstantExpression && (value = (exp = (ConstantExpression)op).getValue()) instanceof Boolean && (filterValue = (Boolean)value).booleanValue()) {
                this.removalQ.add(new Pair(fl, this.mCurrentWalker.getPlan()));
            }
        }
    }
}

