/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.optimizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.ReverseDependencyOrderWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.OptimizerException;

public class MultiQueryOptimizerSpark
extends SparkOpPlanVisitor {
    private static final Log LOG = LogFactory.getLog(MultiQueryOptimizerSpark.class);
    private String scope;
    private NodeIdGenerator nig = NodeIdGenerator.getGenerator();

    public MultiQueryOptimizerSpark(SparkOperPlan plan) {
        super(plan, (PlanWalker<SparkOperator, SparkOperPlan>)new ReverseDependencyOrderWalker<SparkOperator, SparkOperPlan>(plan));
        List roots = plan.getRoots();
        this.scope = ((SparkOperator)roots.get(0)).getOperatorKey().getScope();
    }

    @Override
    public void visitSparkOp(SparkOperator sparkOp) throws VisitorException {
        try {
            if (!sparkOp.isSplitter()) {
                return;
            }
            List<SparkOperator> splittees = ((SparkOperPlan)this.getPlan()).getSuccessors(sparkOp);
            if (splittees == null) {
                return;
            }
            for (SparkOperator splittee : splittees) {
                if (((SparkOperPlan)this.getPlan()).getPredecessors(splittee).size() <= 1) continue;
                return;
            }
            if (splittees.size() == 1) {
                SparkOperator spliter = sparkOp;
                SparkOperator singleSplitee = splittees.get(0);
                List roots = singleSplitee.physicalPlan.getRoots();
                ArrayList rootCopys = new ArrayList(roots);
                Collections.sort(rootCopys);
                List<PhysicalPlan> spliterPhysicalPlan = this.getPhysicalPlans(spliter.physicalPlan, rootCopys.size());
                int i = 0;
                for (PhysicalOperator root : rootCopys) {
                    if (!(root instanceof POLoad)) continue;
                    POLoad load = (POLoad)root;
                    PhysicalPlan plClone = spliterPhysicalPlan.get(i);
                    POStore store = (POStore)plClone.getLeaves().get(0);
                    if (!load.getLFile().getFileName().equals(store.getSFile().getFileName())) continue;
                    plClone.remove(store);
                    PhysicalOperator succOfload = singleSplitee.physicalPlan.getSuccessors(load).get(0);
                    singleSplitee.physicalPlan.remove(load);
                    this.mergePlanAWithPlanB(singleSplitee.physicalPlan, plClone, succOfload);
                    ++i;
                }
                MultiQueryOptimizerSpark.addSubPlanPropertiesToParent(singleSplitee, spliter);
                this.removeSpliter((SparkOperPlan)this.getPlan(), spliter, singleSplitee);
            } else {
                List firstNodeLeaves = sparkOp.physicalPlan.getLeaves();
                PhysicalOperator firstNodeLeaf = firstNodeLeaves.size() > 0 ? (PhysicalOperator)firstNodeLeaves.get(0) : null;
                POStore poStore = null;
                if (firstNodeLeaf != null && firstNodeLeaf instanceof POStore) {
                    poStore = (POStore)firstNodeLeaf;
                    PhysicalOperator predOfPoStore = sparkOp.physicalPlan.getPredecessors(poStore).get(0);
                    sparkOp.physicalPlan.remove(poStore);
                    POSplit poSplit = this.createSplit();
                    ArrayList<SparkOperator> spliteesCopy = new ArrayList<SparkOperator>(splittees);
                    for (SparkOperator splitee : spliteesCopy) {
                        ArrayList rootsOfSplitee = new ArrayList(splitee.physicalPlan.getRoots());
                        for (int i = 0; i < rootsOfSplitee.size(); ++i) {
                            POLoad poLoad;
                            if (!(rootsOfSplitee.get(i) instanceof POLoad) || !(poLoad = (POLoad)rootsOfSplitee.get(i)).getLFile().getFileName().equals(poStore.getSFile().getFileName())) continue;
                            List<POLoad> successorsOfPoLoad = splitee.physicalPlan.getSuccessors(poLoad);
                            ArrayList<POLoad> successorofPoLoadsCopy = new ArrayList<POLoad>(successorsOfPoLoad);
                            splitee.physicalPlan.remove(poLoad);
                            for (PhysicalOperator physicalOperator : successorofPoLoadsCopy) {
                                sparkOp.addMultiQueryOptimizeConnectionItem(physicalOperator.getOperatorKey(), predOfPoStore.getOperatorKey());
                                LOG.debug((Object)String.format("add multiQueryOptimize connection item: to:%s, from:%s for %s", physicalOperator.toString(), predOfPoStore.getOperatorKey().toString(), splitee.getOperatorKey()));
                            }
                        }
                        poSplit.addPlan(splitee.physicalPlan);
                        MultiQueryOptimizerSpark.addSubPlanPropertiesToParent(sparkOp, splitee);
                        this.removeSplittee((SparkOperPlan)this.getPlan(), sparkOp, splitee);
                    }
                    sparkOp.physicalPlan.addAsLeaf(poSplit);
                }
            }
        }
        catch (PlanException e) {
            throw new VisitorException(e);
        }
    }

    private List<PhysicalPlan> getPhysicalPlans(PhysicalPlan physicalPlan, int size) throws OptimizerException {
        ArrayList<PhysicalPlan> ppList = new ArrayList<PhysicalPlan>();
        try {
            ppList.add(physicalPlan);
            for (int i = 1; i < size; ++i) {
                ppList.add(physicalPlan.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            int errCode = 2127;
            String msg = "Internal Error: Cloning of plan failed for optimization.";
            throw new OptimizerException(msg, errCode, 4, (Throwable)e);
        }
        return ppList;
    }

    private void mergePlanAWithPlanB(PhysicalPlan planA, PhysicalPlan planB, PhysicalOperator to) throws PlanException {
        PhysicalOperator predOfStore = (PhysicalOperator)planB.getLeaves().get(0);
        planA.merge(planB);
        planA.connect(predOfStore, to);
    }

    private void removeSpliter(SparkOperPlan plan, SparkOperator spliter, SparkOperator splittee) throws PlanException {
        if (plan.getPredecessors(spliter) != null) {
            ArrayList<SparkOperator> preds = new ArrayList<SparkOperator>(plan.getPredecessors(spliter));
            plan.disconnect(spliter, splittee);
            for (SparkOperator pred : preds) {
                plan.disconnect(pred, spliter);
                plan.connect(pred, splittee);
            }
        }
        plan.remove(spliter);
    }

    private void removeSplittee(SparkOperPlan plan, SparkOperator splitter, SparkOperator splittee) throws PlanException {
        if (plan.getSuccessors(splittee) != null) {
            ArrayList<SparkOperator> succs = new ArrayList<SparkOperator>();
            succs.addAll(plan.getSuccessors(splittee));
            plan.disconnect(splitter, splittee);
            for (SparkOperator succSparkOperator : succs) {
                plan.disconnect(splittee, succSparkOperator);
                plan.connect(splitter, succSparkOperator);
            }
        }
        ((SparkOperPlan)this.getPlan()).remove(splittee);
    }

    private POSplit createSplit() {
        return new POSplit(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
    }

    public static void addSubPlanPropertiesToParent(SparkOperator parentOper, SparkOperator subPlanOper) {
        if (subPlanOper.getCrossKeys() != null) {
            for (String key : subPlanOper.getCrossKeys()) {
                parentOper.addCrossKey(key);
            }
        }
        parentOper.copyFeatures(subPlanOper, null);
        if (subPlanOper.getRequestedParallelism() > parentOper.getRequestedParallelism()) {
            parentOper.setRequestedParallelism(subPlanOper.getRequestedParallelism());
        }
        subPlanOper.setRequestedParallelismByReference(parentOper);
        parentOper.UDFs.addAll(subPlanOper.UDFs);
        parentOper.scalars.addAll(subPlanOper.scalars);
    }
}

