/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.pig.FilterFunc;
import org.apache.pig.builtin.BuildBloomBase;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class Bloom
extends FilterFunc {
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private String bloomFile;
    private BloomFilter filter = null;

    public Bloom() {
    }

    public Bloom(String filename) {
        this.bloomFile = filename;
    }

    @Override
    public Boolean exec(Tuple input) throws IOException {
        byte[] b;
        if (this.filter == null) {
            this.init(input);
        }
        if (this.bloomFile == null) {
            if (input.size() == 2) {
                b = DataType.toBytes(input.get(1));
            } else {
                List<Object> inputList = input.getAll();
                Tuple tuple = mTupleFactory.newTupleNoCopy(inputList.subList(1, inputList.size()));
                b = DataType.toBytes(tuple, (byte)110);
            }
        } else {
            b = input.size() == 1 ? DataType.toBytes(input.get(0)) : DataType.toBytes(input, (byte)110);
        }
        Key k = new Key(b);
        return this.filter.membershipTest(k);
    }

    @Override
    public List<String> getCacheFiles() {
        if (this.bloomFile != null) {
            ArrayList<String> list = new ArrayList<String>(1);
            try {
                list.add(this.bloomFile + "#" + this.getFilenameFromPath(this.bloomFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(Tuple input) throws IOException {
        if (this.bloomFile == null) {
            if (!(input.get(0) instanceof DataByteArray)) throw new IllegalArgumentException("The first argument to the Bloom UDF should be the bloom filter if a bloom file is not specified in the constructor");
            this.filter = BuildBloomBase.bloomIn((DataByteArray)input.get(0));
            return;
        }
        this.filter = new BloomFilter();
        String dir = "./" + this.getFilenameFromPath(this.bloomFile);
        String[] partFiles = new File(dir).list(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                return name.startsWith("part");
            }
        });
        String dcFile = dir + "/" + partFiles[0];
        try (DataInputStream dis = new DataInputStream(new FileInputStream(dcFile));){
            this.filter.readFields((DataInput)dis);
            return;
        }
    }

    public void setFilter(DataByteArray dba) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(dba.get()));
        this.filter = new BloomFilter();
        this.filter.readFields((DataInput)dis);
    }

    private String getFilenameFromPath(String p) throws IOException {
        Path path = new Path(p);
        return path.toUri().getPath().replace("/", "_");
    }
}

