/*
 * Decompiled with CFR 0.152.
 */
package sdsu.rmi.registry;

import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import sdsu.rmi.registry.RemoteRegistrar;
import sdsu.util.ProgramProperties;

public class UniVMRegistry
extends UnicastRemoteObject
implements RemoteRegistrar {
    Registry installee;
    public static final String RMI_NAME = "RemoteRegistrar";

    public UniVMRegistry() throws RemoteException {
        this(1099);
    }

    public UniVMRegistry(int n) throws RemoteException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        this.installee = this.getLocalRegistry(n);
    }

    public void bind(String string, String string2) throws RemoteException, AlreadyBoundException {
        try {
            Remote remote = (Remote)Class.forName(string2).newInstance();
            this.bind(string, remote);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = "Could not find " + string2 + classNotFoundException.getMessage();
            throw new RemoteException(string3);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string4 = "Could not access " + string2 + illegalAccessException.getMessage();
            throw new RemoteException(string4);
        }
        catch (InstantiationException instantiationException) {
            String string5 = "Could not instantiate " + string2 + instantiationException.getMessage();
            throw new RemoteException(string5);
        }
    }

    public void bind(String string, Remote remote) throws RemoteException, AlreadyBoundException {
        this.installee.bind(string, remote);
    }

    protected Registry getLocalRegistry(int n) throws RemoteException {
        try {
            return LocateRegistry.getRegistry(n);
        }
        catch (RemoteException remoteException) {
            return LocateRegistry.createRegistry(n);
        }
    }

    public String[] list() throws RemoteException, AccessException {
        return this.installee.list();
    }

    public static void main(String[] stringArray) {
        try {
            ProgramProperties programProperties = new ProgramProperties(stringArray);
            int n = programProperties.getInt("p", 1099);
            UniVMRegistry uniVMRegistry = new UniVMRegistry(n);
            uniVMRegistry.rebind(RMI_NAME, uniVMRegistry);
            System.out.println("UniVMRegistry bound in registry");
            String[] stringArray2 = uniVMRegistry.list();
            if (stringArray2.length > 0) {
                System.out.println("The server on port " + n + " now contains objects bound to the names: ");
            }
            int n2 = 0;
            while (n2 < stringArray2.length) {
                System.out.println(stringArray2[n2]);
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println("Error in installing Registry: ");
            exception.printStackTrace();
        }
    }

    public void rebind(String string, String string2) throws RemoteException {
        try {
            Remote remote = (Remote)Class.forName(string2).newInstance();
            this.rebind(string, remote);
        }
        catch (Exception exception) {
            String string3 = "Installing " + string2 + " failed. " + "Exception: " + exception.getMessage();
            throw new RemoteException(string3);
        }
    }

    public void rebind(String string, Remote remote) throws RemoteException {
        this.installee.rebind(string, remote);
    }
}

