/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, SmallTests.class})
public class TestColumnFamilyDescriptorLowerCaseEnum {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestColumnFamilyDescriptorLowerCaseEnum.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestColumnFamilyDescriptorLowerCaseEnum.class);

    private Method getSetMethod(Method getMethod, Class<?> enumType) throws NoSuchMethodException {
        String methodName = getMethod.getName().replaceFirst("get", "set");
        return ColumnFamilyDescriptorBuilder.class.getMethod(methodName, enumType);
    }

    private Enum<?> getEnumValue(Class<?> enumType) {
        for (Enum enumConst : enumType.asSubclass(Enum.class).getEnumConstants()) {
            if (enumConst.name().equalsIgnoreCase("NONE") || enumConst.name().equals("DEFAULT")) continue;
            return enumConst;
        }
        throw new NoSuchElementException(enumType.getName());
    }

    private boolean contains(Collection<Enum<?>> enumConsts, String value) {
        return enumConsts.stream().anyMatch(e -> e.name().equals(value));
    }

    @Test
    public void test() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        HashMap getMethod2Value = new HashMap();
        ColumnFamilyDescriptorBuilder builder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"test"));
        for (Method method : ColumnFamilyDescriptor.class.getMethods()) {
            if (method.getParameterCount() != 0 || !method.getReturnType().isEnum()) continue;
            LOG.info("Checking " + method);
            Class<?> enumType = method.getReturnType();
            Method setMethod = this.getSetMethod(method, enumType);
            Enum<?> enumConst = this.getEnumValue(enumType);
            LOG.info("Using " + setMethod + " to set the value to " + enumConst);
            setMethod.invoke((Object)builder, enumConst);
            getMethod2Value.put(method, enumConst);
        }
        ColumnFamilyDescriptor desc = builder.build();
        ColumnFamilyDescriptorBuilder builder2 = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"test2"));
        desc.getValues().forEach((k, v) -> {
            LOG.info(k.toString() + "=>" + v.toString());
            String str = Bytes.toString((byte[])v.get(), (int)v.getOffset(), (int)v.getLength());
            if (this.contains(getMethod2Value.values(), str)) {
                LOG.info("Set to lower case " + str.toLowerCase());
                builder2.setValue(k, new Bytes(Bytes.toBytes((String)str.toLowerCase())));
            }
        });
        ColumnFamilyDescriptor desc2 = builder2.build();
        for (Map.Entry entry : getMethod2Value.entrySet()) {
            Assert.assertEquals((String)(entry.getKey() + " should return " + entry.getValue()), entry.getValue(), (Object)((Method)entry.getKey()).invoke((Object)desc2, new Object[0]));
        }
    }
}

