/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.master.ReplicationHFileCleaner;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestReplicationHFileCleaner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationHFileCleaner.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationHFileCleaner.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Server server;
    private static ReplicationQueueStorage rq;
    private static ReplicationPeers rp;
    private static final String peerId = "TestReplicationHFileCleaner";
    private static Configuration conf;
    static FileSystem fs;
    Path root;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        server = new DummyServer();
        conf.setBoolean("hbase.replication.bulkload.enabled", true);
        HMaster.decorateMasterConfiguration((Configuration)conf);
        rp = ReplicationFactory.getReplicationPeers((ZKWatcher)server.getZooKeeper(), (Configuration)conf);
        rp.init();
        rq = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)server.getZooKeeper(), (Configuration)conf);
        fs = FileSystem.get((Configuration)conf);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Before
    public void setup() throws ReplicationException, IOException {
        this.root = TEST_UTIL.getDataTestDirOnTestFS();
        rp.getPeerStorage().addPeer(peerId, ReplicationPeerConfig.newBuilder().setClusterKey(TEST_UTIL.getClusterKey()).build(), true);
        rq.addPeerToHFileRefs(peerId);
    }

    @After
    public void cleanup() throws ReplicationException {
        try {
            fs.delete(this.root, true);
        }
        catch (IOException e) {
            LOG.warn("Failed to delete files recursively from path " + this.root);
        }
        rq.removeHFileRefs(peerId, rq.getReplicableHFiles(peerId));
        rp.getPeerStorage().removePeer(peerId);
    }

    @Test
    public void testIsFileDeletable() throws IOException, ReplicationException {
        Path file = new Path(this.root, "testIsFileDeletableWithNoHFileRefs");
        fs.createNewFile(file);
        Assert.assertTrue((String)"Test file not created!", (boolean)fs.exists(file));
        ReplicationHFileCleaner cleaner = new ReplicationHFileCleaner();
        cleaner.setConf(conf);
        Assert.assertTrue((String)"Cleaner should allow to delete this file as there is no hfile reference node for it in the queue.", (boolean)cleaner.isFileDeletable(fs.getFileStatus(file)));
        ArrayList<Pair> files = new ArrayList<Pair>(1);
        files.add(new Pair(null, (Object)file));
        rq.addHFileRefs(peerId, files);
        Assert.assertFalse((String)"Cleaner should not allow to delete this file as there is a hfile reference node for it in the queue.", (boolean)cleaner.isFileDeletable(fs.getFileStatus(file)));
    }

    @Test
    public void testGetDeletableFiles() throws Exception {
        int i;
        Path notDeletablefile = new Path(this.root, "testGetDeletableFiles_1");
        fs.createNewFile(notDeletablefile);
        Assert.assertTrue((String)"Test file not created!", (boolean)fs.exists(notDeletablefile));
        Path deletablefile = new Path(this.root, "testGetDeletableFiles_2");
        fs.createNewFile(deletablefile);
        Assert.assertTrue((String)"Test file not created!", (boolean)fs.exists(deletablefile));
        ArrayList<FileStatus> files = new ArrayList<FileStatus>(2);
        FileStatus f = new FileStatus();
        f.setPath(deletablefile);
        files.add(f);
        f = new FileStatus();
        f.setPath(notDeletablefile);
        files.add(f);
        ArrayList<Pair> hfiles = new ArrayList<Pair>(1);
        hfiles.add(new Pair(null, (Object)notDeletablefile));
        rq.addHFileRefs(peerId, hfiles);
        ReplicationHFileCleaner cleaner = new ReplicationHFileCleaner();
        cleaner.setConf(conf);
        Iterator deletableFilesIterator = cleaner.getDeletableFiles(files).iterator();
        for (i = 0; deletableFilesIterator.hasNext() && i < 2; ++i) {
        }
        if (i > 2) {
            Assert.fail((String)("File " + notDeletablefile + " should not be deletable as its hfile reference node is not added."));
        }
        Assert.assertTrue((boolean)((FileStatus)deletableFilesIterator.next()).getPath().equals((Object)deletablefile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZooKeeperAbort() throws Exception {
        ReplicationHFileCleaner cleaner = new ReplicationHFileCleaner();
        ArrayList dummyFiles = Lists.newArrayList((Object[])new FileStatus[]{new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("hfile1")), new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("hfile2"))});
        try (FaultyZooKeeperWatcher faultyZK = new FaultyZooKeeperWatcher(conf, "testZooKeeperAbort-faulty", null);){
            faultyZK.init();
            cleaner.setConf(conf, (ZKWatcher)faultyZK);
            Iterable toDelete = cleaner.getDeletableFiles((Iterable)dummyFiles);
            Assert.assertFalse((boolean)toDelete.iterator().hasNext());
            Assert.assertFalse((boolean)cleaner.isStopped());
        }
        cleaner = new ReplicationHFileCleaner();
        try (ZKWatcher zkw = new ZKWatcher(conf, "testZooKeeperAbort-normal", null);){
            cleaner.setConf(conf, zkw);
            Iterable filesToDelete = cleaner.getDeletableFiles((Iterable)dummyFiles);
            Iterator iter = filesToDelete.iterator();
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)new Path("hfile1"), (Object)((FileStatus)iter.next()).getPath());
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)new Path("hfile2"), (Object)((FileStatus)iter.next()).getPath());
            Assert.assertFalse((boolean)iter.hasNext());
        }
    }

    static {
        conf = TEST_UTIL.getConfiguration();
        fs = null;
    }

    static class FaultyZooKeeperWatcher
    extends ZKWatcher {
        private RecoverableZooKeeper zk;

        public FaultyZooKeeperWatcher(Configuration conf, String identifier, Abortable abortable) throws ZooKeeperConnectionException, IOException {
            super(conf, identifier, abortable);
        }

        public void init() throws Exception {
            this.zk = (RecoverableZooKeeper)Mockito.spy((Object)super.getRecoverableZooKeeper());
            ((RecoverableZooKeeper)Mockito.doThrow((Throwable[])new Throwable[]{new KeeperException.ConnectionLossException()}).when((Object)this.zk)).getData("/hbase/replication/hfile-refs", null, new Stat());
        }

        public RecoverableZooKeeper getRecoverableZooKeeper() {
            return this.zk;
        }
    }

    static class DummyServer
    implements Server {
        DummyServer() {
        }

        public Configuration getConfiguration() {
            return TEST_UTIL.getConfiguration();
        }

        public ZKWatcher getZooKeeper() {
            try {
                return new ZKWatcher(this.getConfiguration(), "dummy server", (Abortable)this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)"regionserver,60020,000000");
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
        }

        public boolean isStopped() {
            return false;
        }

        public ChoreService getChoreService() {
            return null;
        }

        public ClusterConnection getClusterConnection() {
            return null;
        }

        public FileSystem getFileSystem() {
            return null;
        }

        public boolean isStopping() {
            return false;
        }

        public Connection createConnection(Configuration conf) throws IOException {
            return null;
        }
    }
}

