/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.handler;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.accumulo.server.security.handler.ZKSecurityTool;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKAuthorizor
implements Authorizor {
    private static final Logger log = LoggerFactory.getLogger(ZKAuthorizor.class);
    private static Authorizor zkAuthorizorInstance = null;
    private final String ZKUserAuths = "/Authorizations";
    private String ZKUserPath;
    private final ZooCache zooCache = new ZooCache();

    public static synchronized Authorizor getInstance() {
        if (zkAuthorizorInstance == null) {
            zkAuthorizorInstance = new ZKAuthorizor();
        }
        return zkAuthorizorInstance;
    }

    @Override
    public void initialize(String instanceId, boolean initialize) {
        this.ZKUserPath = ZKSecurityTool.getInstancePath(instanceId) + "/users";
    }

    @Override
    public Authorizations getCachedUserAuthorizations(String user) {
        byte[] authsBytes = this.zooCache.get(this.ZKUserPath + "/" + user + "/Authorizations");
        if (authsBytes != null) {
            return ZKSecurityTool.convertAuthorizations(authsBytes);
        }
        return Authorizations.EMPTY;
    }

    @Override
    public boolean validSecurityHandlers(Authenticator auth, PermissionHandler pm) {
        return true;
    }

    @Override
    public void initializeSecurity(TCredentials itw, String rootuser) throws AccumuloSecurityException {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        TreeSet<SystemPermission> rootPerms = new TreeSet<SystemPermission>();
        for (SystemPermission p : SystemPermission.values()) {
            rootPerms.add(p);
        }
        HashMap<String, Set<TablePermission>> tablePerms = new HashMap<String, Set<TablePermission>>();
        tablePerms.put("!0", Collections.singleton(TablePermission.ALTER_TABLE));
        tablePerms.put("+r", Collections.singleton(TablePermission.ALTER_TABLE));
        try {
            if (!zoo.exists(this.ZKUserPath)) {
                zoo.putPersistentData(this.ZKUserPath, rootuser.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
            }
            this.initUser(rootuser);
            zoo.putPersistentData(this.ZKUserPath + "/" + rootuser + "/Authorizations", ZKSecurityTool.convertAuthorizations(Authorizations.EMPTY), ZooUtil.NodeExistsPolicy.FAIL);
        }
        catch (KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initUser(String user) throws AccumuloSecurityException {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        try {
            zoo.putPersistentData(this.ZKUserPath + "/" + user, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        }
        catch (KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropUser(String user) throws AccumuloSecurityException {
        try {
            ZooCache zooCache = this.zooCache;
            synchronized (zooCache) {
                ZooReaderWriter zoo = ZooReaderWriter.getInstance();
                zoo.recursiveDelete(this.ZKUserPath + "/" + user + "/Authorizations", ZooUtil.NodeMissingPolicy.SKIP);
                this.zooCache.clear(this.ZKUserPath + "/" + user);
            }
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        catch (KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            if (e.code().equals((Object)KeeperException.Code.NONODE)) {
                throw new AccumuloSecurityException(user, SecurityErrorCode.USER_DOESNT_EXIST, (Throwable)e);
            }
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeAuthorizations(String user, Authorizations authorizations) throws AccumuloSecurityException {
        try {
            ZooCache zooCache = this.zooCache;
            synchronized (zooCache) {
                this.zooCache.clear();
                ZooReaderWriter.getInstance().putPersistentData(this.ZKUserPath + "/" + user + "/Authorizations", ZKSecurityTool.convertAuthorizations(authorizations), ZooUtil.NodeExistsPolicy.OVERWRITE);
            }
        }
        catch (KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isValidAuthorizations(String user, List<ByteBuffer> auths) throws AccumuloSecurityException {
        if (auths.isEmpty()) {
            return true;
        }
        Authorizations userauths = this.getCachedUserAuthorizations(user);
        for (ByteBuffer auth : auths) {
            if (userauths.contains(ByteBufferUtil.toBytes((ByteBuffer)auth))) continue;
            return false;
        }
        return true;
    }
}

