/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.ProxyUserAuthenticationFilterInitializer;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.apache.hadoop.security.authentication.util.StringSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.StringSignerSecretProviderCreator;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHttpServerWithSpnego {
    static final Log LOG = LogFactory.getLog(TestHttpServerWithSpnego.class);
    private static final String SECRET_STR = "secret";
    private static final String HTTP_USER = "HTTP";
    private static final String PREFIX = "hadoop.http.authentication.";
    private static final long TIMEOUT = 20000L;
    private static File httpSpnegoKeytabFile = new File(KerberosTestUtils.getKeytabFile());
    private static String httpSpnegoPrincipal = KerberosTestUtils.getServerPrincipal();
    private static String realm = KerberosTestUtils.getRealm();
    private static File testRootDir = new File("target", TestHttpServerWithSpnego.class.getName() + "-root");
    private static MiniKdc testMiniKDC;
    private static File secretFile;

    @BeforeClass
    public static void setUp() throws Exception {
        try {
            testMiniKDC = new MiniKdc(MiniKdc.createConf(), testRootDir);
            testMiniKDC.start();
            testMiniKDC.createPrincipal(httpSpnegoKeytabFile, new String[]{"HTTP/localhost"});
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Couldn't setup MiniKDC", (boolean)false);
        }
        FileWriter w = new FileWriter(secretFile);
        w.write(SECRET_STR);
        ((Writer)w).close();
    }

    @AfterClass
    public static void tearDown() {
        if (testMiniKDC != null) {
            testMiniKDC.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthenticationWithProxyUser() throws Exception {
        Configuration spengoConf = this.getSpengoConf(new Configuration());
        System.setProperty("hadoop.log.dir", testRootDir.getAbsolutePath());
        UserGroupInformation.createUserForTesting((String)"userA", (String[])new String[]{"groupA", "groupB"});
        UserGroupInformation.createUserForTesting((String)"userB", (String[])new String[]{"groupB"});
        UserGroupInformation.createUserForTesting((String)"userC", (String[])new String[]{"groupC"});
        spengoConf.set("hadoop.proxyuser.userA.hosts", "*");
        spengoConf.set("hadoop.proxyuser.userA.groups", "groupB");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)spengoConf);
        HttpServer2 httpServer = null;
        try {
            HttpURLConnection conn;
            httpServer = this.getCommonBuilder().setConf(spengoConf).setACL(new AccessControlList("userA groupA")).build();
            httpServer.start();
            Signer signer = this.getSignerToEncrypt();
            AuthenticatedURL.Token token = this.getEncryptedAuthToken(signer, "userA");
            String serverURL = "http://" + NetUtils.getHostPortString((InetSocketAddress)httpServer.getConnectorAddress(0)) + "/";
            AuthenticatedURL authUrl = new AuthenticatedURL();
            for (String servlet : new String[]{"stacks", "jmx", "conf"}) {
                conn = authUrl.openConnection(new URL(serverURL + servlet + "?doAs=userB"), token);
                Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            }
            for (String servlet : new String[]{"stacks", "jmx", "conf"}) {
                conn = authUrl.openConnection(new URL(serverURL + servlet + "?doAs=userC"), token);
                Assert.assertEquals((long)403L, (long)conn.getResponseCode());
            }
            for (String servlet : new String[]{"logLevel", "logs"}) {
                conn = authUrl.openConnection(new URL(serverURL + servlet), token);
                Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            }
            token = this.getEncryptedAuthToken(signer, "userB");
            for (String servlet : new String[]{"logLevel", "logs"}) {
                conn = authUrl.openConnection(new URL(serverURL + servlet), token);
                Assert.assertEquals((long)403L, (long)conn.getResponseCode());
            }
        }
        finally {
            if (httpServer != null) {
                httpServer.stop();
            }
        }
    }

    private AuthenticatedURL.Token getEncryptedAuthToken(Signer signer, String user) throws Exception {
        AuthenticationToken token = new AuthenticationToken(user, user, "kerberos");
        token.setExpires(System.currentTimeMillis() + 20000L);
        return new AuthenticatedURL.Token(signer.sign(token.toString()));
    }

    private Signer getSignerToEncrypt() throws Exception {
        StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
        Properties secretProviderProps = new Properties();
        secretProviderProps.setProperty("signature.secret", SECRET_STR);
        secretProvider.init(secretProviderProps, null, 20000L);
        return new Signer((SignerSecretProvider)secretProvider);
    }

    private Configuration getSpengoConf(Configuration conf) {
        conf = new Configuration();
        conf.set("hadoop.http.filter.initializers", ProxyUserAuthenticationFilterInitializer.class.getName());
        conf.set("hadoop.http.authentication.type", "kerberos");
        conf.setBoolean("hadoop.http.authentication.simple.anonymous.allowed", false);
        conf.set("hadoop.http.authentication.signature.secret.file", secretFile.getAbsolutePath());
        conf.set("hadoop.http.authentication.kerberos.keytab", httpSpnegoKeytabFile.getAbsolutePath());
        conf.set("hadoop.http.authentication.kerberos.principal", httpSpnegoPrincipal);
        conf.set("hadoop.http.authentication.cookie.domain", realm);
        conf.setBoolean("hadoop.security.authorization", true);
        return conf;
    }

    private HttpServer2.Builder getCommonBuilder() throws Exception {
        return new HttpServer2.Builder().setName("test").addEndpoint(new URI("http://localhost:0")).setFindPort(true);
    }

    static {
        secretFile = new File(testRootDir, SECRET_STR);
    }
}

