/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file;

import java.io.IOException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.file.BloomFilterLayer;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.map.MapFileOperations;
import org.apache.accumulo.core.file.rfile.RFileOperations;
import org.apache.hadoop.fs.Path;

class DispatchingFileFactory
extends FileOperations {
    DispatchingFileFactory() {
    }

    private FileOperations findFileFactory(FileOperations.FileAccessOperation<?> options) {
        String file = options.getFilename();
        Path p = new Path(file);
        String name = p.getName();
        if (name.startsWith("map_")) {
            return new MapFileOperations();
        }
        String[] sp = name.split("\\.");
        if (sp.length < 2) {
            throw new IllegalArgumentException("File name " + name + " has no extension");
        }
        String extension = sp[sp.length - 1];
        if (extension.equals("map") || extension.equals("map_tmp")) {
            return new MapFileOperations();
        }
        if (extension.equals("rf") || extension.equals("rf_tmp")) {
            return new RFileOperations();
        }
        throw new IllegalArgumentException("File type " + extension + " not supported");
    }

    private static <T extends FileOperations.FileReaderOperation<T>> T selectivelyDisableCaches(T input) {
        if (!input.getTableConfiguration().getBoolean(Property.TABLE_INDEXCACHE_ENABLED)) {
            input = input.withIndexCache(null);
        }
        if (!input.getTableConfiguration().getBoolean(Property.TABLE_BLOCKCACHE_ENABLED)) {
            input = input.withDataCache(null);
        }
        return input;
    }

    @Override
    protected long getFileSize(FileOperations.GetFileSizeOperation options) throws IOException {
        return this.findFileFactory(options).getFileSize(options);
    }

    @Override
    protected FileSKVWriter openWriter(FileOperations.OpenWriterOperation options) throws IOException {
        FileSKVWriter writer = this.findFileFactory(options).openWriter(options);
        if (options.getTableConfiguration().getBoolean(Property.TABLE_BLOOM_ENABLED)) {
            return new BloomFilterLayer.Writer(writer, options.getTableConfiguration());
        }
        return writer;
    }

    @Override
    protected FileSKVIterator openIndex(FileOperations.OpenIndexOperation options) throws IOException {
        options = DispatchingFileFactory.selectivelyDisableCaches(options);
        return this.findFileFactory(options).openIndex(options);
    }

    @Override
    protected FileSKVIterator openReader(FileOperations.OpenReaderOperation options) throws IOException {
        options = DispatchingFileFactory.selectivelyDisableCaches(options);
        FileSKVIterator iter = this.findFileFactory(options).openReader(options);
        if (options.getTableConfiguration().getBoolean(Property.TABLE_BLOOM_ENABLED)) {
            return new BloomFilterLayer.Reader(iter, options.getTableConfiguration());
        }
        return iter;
    }

    @Override
    protected FileSKVIterator openScanReader(FileOperations.OpenScanReaderOperation options) throws IOException {
        options = DispatchingFileFactory.selectivelyDisableCaches(options);
        return this.findFileFactory(options).openScanReader(options);
    }
}

