/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.security;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.crypto.random.CryptoRandomFactory;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.commons.crypto.stream.CryptoOutputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.util.CryptoUtils;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.security.CryptoStreamUtils;
import org.slf4j.Logger;
import org.sparkproject.guava.io.ByteStreams;
import scala.Function0;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class CryptoStreamUtils$
implements Logging {
    public static CryptoStreamUtils$ MODULE$;
    private final int IV_LENGTH_IN_BYTES;
    private final String SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CryptoStreamUtils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int IV_LENGTH_IN_BYTES() {
        return this.IV_LENGTH_IN_BYTES;
    }

    public String SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX() {
        return this.SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX;
    }

    public OutputStream createCryptoOutputStream(OutputStream os, SparkConf sparkConf, byte[] key) {
        CryptoStreamUtils.CryptoParams params = new CryptoStreamUtils.CryptoParams(key, sparkConf);
        byte[] iv = this.createInitializationVector(params.conf());
        os.write(iv);
        return new CryptoStreamUtils.ErrorHandlingOutputStream((OutputStream)new CryptoOutputStream(params.transformation(), params.conf(), os, (Key)params.keySpec(), (AlgorithmParameterSpec)new IvParameterSpec(iv)), os);
    }

    public WritableByteChannel createWritableChannel(WritableByteChannel channel, SparkConf sparkConf, byte[] key) {
        CryptoStreamUtils.CryptoParams params = new CryptoStreamUtils.CryptoParams(key, sparkConf);
        byte[] iv = this.createInitializationVector(params.conf());
        CryptoStreamUtils.CryptoHelperChannel helper = new CryptoStreamUtils.CryptoHelperChannel(channel);
        helper.write(ByteBuffer.wrap(iv));
        return new CryptoStreamUtils.ErrorHandlingWritableChannel((WritableByteChannel)new CryptoOutputStream(params.transformation(), params.conf(), (WritableByteChannel)helper, (Key)params.keySpec(), (AlgorithmParameterSpec)new IvParameterSpec(iv)), helper);
    }

    public InputStream createCryptoInputStream(InputStream is, SparkConf sparkConf, byte[] key) {
        byte[] iv = new byte[this.IV_LENGTH_IN_BYTES()];
        ByteStreams.readFully((InputStream)is, (byte[])iv);
        CryptoStreamUtils.CryptoParams params = new CryptoStreamUtils.CryptoParams(key, sparkConf);
        return new CryptoStreamUtils.ErrorHandlingInputStream((InputStream)new CryptoInputStream(params.transformation(), params.conf(), is, (Key)params.keySpec(), (AlgorithmParameterSpec)new IvParameterSpec(iv)), is);
    }

    public ReadableByteChannel createReadableChannel(ReadableByteChannel channel, SparkConf sparkConf, byte[] key) {
        byte[] iv = new byte[this.IV_LENGTH_IN_BYTES()];
        ByteBuffer buf = ByteBuffer.wrap(iv);
        JavaUtils.readFully((ReadableByteChannel)channel, (ByteBuffer)buf);
        CryptoStreamUtils.CryptoParams params = new CryptoStreamUtils.CryptoParams(key, sparkConf);
        return new CryptoStreamUtils.ErrorHandlingReadableChannel((ReadableByteChannel)new CryptoInputStream(params.transformation(), params.conf(), channel, (Key)params.keySpec(), (AlgorithmParameterSpec)new IvParameterSpec(iv)), channel);
    }

    public Properties toCryptoConf(SparkConf conf) {
        return CryptoUtils.toCryptoConf((String)this.SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX(), ((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).toMap(Predef$.MODULE$.$conforms())).asJava()).entrySet());
    }

    public byte[] createKey(SparkConf conf) {
        int keyLen = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.IO_ENCRYPTION_KEY_SIZE_BITS()));
        String ioKeyGenAlgorithm = conf.get(package$.MODULE$.IO_ENCRYPTION_KEYGEN_ALGORITHM());
        KeyGenerator keyGen = KeyGenerator.getInstance(ioKeyGenAlgorithm);
        keyGen.init(keyLen);
        return keyGen.generateKey().getEncoded();
    }

    private byte[] createInitializationVector(Properties properties) {
        byte[] iv;
        block0: {
            iv = new byte[this.IV_LENGTH_IN_BYTES()];
            long initialIVStart = System.nanoTime();
            CryptoRandomFactory.getCryptoRandom((Properties)properties).nextBytes(iv);
            long initialIVFinish = System.nanoTime();
            long initialIVTime = TimeUnit.NANOSECONDS.toMillis(initialIVFinish - initialIVStart);
            if (initialIVTime <= 2000L) break block0;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("It costs ").append(initialIVTime).append(" milliseconds to create the Initialization Vector ").append("used by CryptoStream").toString());
        }
        return iv;
    }

    private CryptoStreamUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.IV_LENGTH_IN_BYTES = 16;
        this.SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX = "spark.io.encryption.commons.config.";
    }
}

