/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// MonitoringFilterResult is the corresponding interface of MonitoringFilterResult
type MonitoringFilterResult interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// IsMonitoringFilterResult is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMonitoringFilterResult()
	// CreateBuilder creates a MonitoringFilterResultBuilder
	CreateMonitoringFilterResultBuilder() MonitoringFilterResultBuilder
}

// _MonitoringFilterResult is the data-structure of this message
type _MonitoringFilterResult struct {
	ExtensionObjectDefinitionContract
}

var _ MonitoringFilterResult = (*_MonitoringFilterResult)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_MonitoringFilterResult)(nil)

// NewMonitoringFilterResult factory function for _MonitoringFilterResult
func NewMonitoringFilterResult() *_MonitoringFilterResult {
	_result := &_MonitoringFilterResult{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// MonitoringFilterResultBuilder is a builder for MonitoringFilterResult
type MonitoringFilterResultBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() MonitoringFilterResultBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the MonitoringFilterResult or returns an error if something is wrong
	Build() (MonitoringFilterResult, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() MonitoringFilterResult
}

// NewMonitoringFilterResultBuilder() creates a MonitoringFilterResultBuilder
func NewMonitoringFilterResultBuilder() MonitoringFilterResultBuilder {
	return &_MonitoringFilterResultBuilder{_MonitoringFilterResult: new(_MonitoringFilterResult)}
}

type _MonitoringFilterResultBuilder struct {
	*_MonitoringFilterResult

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (MonitoringFilterResultBuilder) = (*_MonitoringFilterResultBuilder)(nil)

func (b *_MonitoringFilterResultBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._MonitoringFilterResult
}

func (b *_MonitoringFilterResultBuilder) WithMandatoryFields() MonitoringFilterResultBuilder {
	return b
}

func (b *_MonitoringFilterResultBuilder) Build() (MonitoringFilterResult, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._MonitoringFilterResult.deepCopy(), nil
}

func (b *_MonitoringFilterResultBuilder) MustBuild() MonitoringFilterResult {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MonitoringFilterResultBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_MonitoringFilterResultBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_MonitoringFilterResultBuilder) DeepCopy() any {
	_copy := b.CreateMonitoringFilterResultBuilder().(*_MonitoringFilterResultBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateMonitoringFilterResultBuilder creates a MonitoringFilterResultBuilder
func (b *_MonitoringFilterResult) CreateMonitoringFilterResultBuilder() MonitoringFilterResultBuilder {
	if b == nil {
		return NewMonitoringFilterResultBuilder()
	}
	return &_MonitoringFilterResultBuilder{_MonitoringFilterResult: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_MonitoringFilterResult) GetExtensionId() int32 {
	return int32(733)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_MonitoringFilterResult) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

// Deprecated: use the interface for direct cast
func CastMonitoringFilterResult(structType any) MonitoringFilterResult {
	if casted, ok := structType.(MonitoringFilterResult); ok {
		return casted
	}
	if casted, ok := structType.(*MonitoringFilterResult); ok {
		return *casted
	}
	return nil
}

func (m *_MonitoringFilterResult) GetTypeName() string {
	return "MonitoringFilterResult"
}

func (m *_MonitoringFilterResult) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_MonitoringFilterResult) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_MonitoringFilterResult) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__monitoringFilterResult MonitoringFilterResult, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("MonitoringFilterResult"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for MonitoringFilterResult")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("MonitoringFilterResult"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for MonitoringFilterResult")
	}

	return m, nil
}

func (m *_MonitoringFilterResult) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_MonitoringFilterResult) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("MonitoringFilterResult"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for MonitoringFilterResult")
		}

		if popErr := writeBuffer.PopContext("MonitoringFilterResult"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for MonitoringFilterResult")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_MonitoringFilterResult) IsMonitoringFilterResult() {}

func (m *_MonitoringFilterResult) DeepCopy() any {
	return m.deepCopy()
}

func (m *_MonitoringFilterResult) deepCopy() *_MonitoringFilterResult {
	if m == nil {
		return nil
	}
	_MonitoringFilterResultCopy := &_MonitoringFilterResult{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
	}
	_MonitoringFilterResultCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _MonitoringFilterResultCopy
}

func (m *_MonitoringFilterResult) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
