/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BACnetServicesSupported {
  ACKNOWLEDGE_ALARM((short) 0),
  CONFIRMED_COV_NOTIFICATION((short) 1),
  CONFIRMED_EVENT_NOTIFICATION((short) 2),
  GET_ALARM_SUMMARY((short) 3),
  GET_ENROLLMENT_SUMMARY((short) 4),
  SUBSCRIBE_COV((short) 5),
  ATOMIC_READ_FILE((short) 6),
  ATOMIC_WRITE_FILE((short) 7),
  ADD_LIST_ELEMENT((short) 8),
  REMOVE_LIST_ELEMENT((short) 9),
  CREATE_OBJECT((short) 10),
  DELETE_OBJECT((short) 11),
  READ_PROPERTY((short) 12),
  READ_PROPERTY_MULTIPLE((short) 14),
  WRITE_PROPERTY((short) 15),
  WRITE_PROPERTY_MULTIPLE((short) 16),
  DEVICE_COMMUNICATION_CONTROL((short) 17),
  CONFIRMED_PRIVATE_TRANSFER((short) 18),
  CONFIRMED_TEXT_MESSAGE((short) 19),
  REINITIALIZE_DEVICE((short) 20),
  VT_OPEN((short) 21),
  VT_CLOSE((short) 22),
  VT_DATA((short) 23),
  I_AM((short) 26),
  I_HAVE((short) 27),
  UNCONFIRMED_COV_NOTIFICATION((short) 28),
  UNCONFIRMED_EVENT_NOTIFICATION((short) 29),
  UNCONFIRMED_PRIVATE_TRANSFER((short) 30),
  UNCONFIRMED_TEXT_MESSAGE((short) 31),
  TIME_SYNCHRONIZATION((short) 32),
  WHO_HAS((short) 33),
  WHO_IS((short) 34),
  READ_RANGE((short) 35),
  UTC_TIME_SYNCHRONIZATION((short) 36),
  LIFE_SAFETY_OPERATION((short) 37),
  SUBSCRIBE_COV_PROPERTY((short) 38),
  GET_EVENT_INFORMATION((short) 39),
  WRITE_GROUP((short) 40),
  SUBSCRIBE_COV_PROPERTY_MULTIPLE((short) 41),
  CONFIRMED_COV_NOTIFICATION_MULTIPLE((short) 42),
  UNCONFIRMED_COV_NOTIFICATION_MULTIPLE((short) 43);
  private static final Map<Short, BACnetServicesSupported> map;

  static {
    map = new HashMap<>();
    for (BACnetServicesSupported value : BACnetServicesSupported.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;

  BACnetServicesSupported(short value) {
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  public static BACnetServicesSupported enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
