/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto.decoder.protobufnative;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.DynamicMessage;
import io.airlift.log.Logger;
import io.netty.buffer.ByteBuf;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeRecord;
import org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeSchema;
import org.apache.pulsar.sql.presto.PulsarRowDecoder;
import org.apache.pulsar.sql.presto.decoder.protobufnative.PulsarProtobufNativeColumnDecoder;

public class PulsarProtobufNativeRowDecoder
implements PulsarRowDecoder {
    private final GenericProtobufNativeSchema genericProtobufNativeSchema;
    private final Map<DecoderColumnHandle, PulsarProtobufNativeColumnDecoder> columnDecoders;
    private static final Logger log = Logger.get(PulsarProtobufNativeRowDecoder.class);

    public PulsarProtobufNativeRowDecoder(GenericProtobufNativeSchema genericProtobufNativeSchema, Set<DecoderColumnHandle> columns) {
        this.genericProtobufNativeSchema = Objects.requireNonNull(genericProtobufNativeSchema, "genericProtobufNativeSchema is null");
        this.columnDecoders = (Map)columns.stream().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), this::createColumnDecoder));
    }

    private PulsarProtobufNativeColumnDecoder createColumnDecoder(DecoderColumnHandle columnHandle) {
        return new PulsarProtobufNativeColumnDecoder(columnHandle);
    }

    @Override
    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(ByteBuf byteBuf) {
        DynamicMessage dynamicMessage;
        try {
            GenericProtobufNativeRecord record = (GenericProtobufNativeRecord)this.genericProtobufNativeSchema.decode(byteBuf);
            dynamicMessage = record.getProtobufRecord();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Decoding protobuf record failed.", (Throwable)e);
        }
        return Optional.of((Map)this.columnDecoders.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((PulsarProtobufNativeColumnDecoder)entry.getValue()).decodeField(dynamicMessage))));
    }
}

