/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionId;
import io.trino.spi.type.Type;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;

public class FunctionBinding {
    private final FunctionId functionId;
    private final BoundSignature boundSignature;
    private final Map<String, Type> typeVariables;
    private final Map<String, Long> longVariables;

    public FunctionBinding(FunctionId functionId, BoundSignature boundSignature, Map<String, Type> typeVariables, Map<String, Long> longVariables) {
        this.functionId = Objects.requireNonNull(functionId, "functionId is null");
        this.boundSignature = Objects.requireNonNull(boundSignature, "boundSignature is null");
        this.typeVariables = ImmutableSortedMap.copyOf(Objects.requireNonNull(typeVariables, "typeVariables is null"), (Comparator)String.CASE_INSENSITIVE_ORDER);
        this.longVariables = ImmutableSortedMap.copyOf(Objects.requireNonNull(longVariables, "longVariables is null"), (Comparator)String.CASE_INSENSITIVE_ORDER);
    }

    public FunctionId getFunctionId() {
        return this.functionId;
    }

    public BoundSignature getBoundSignature() {
        return this.boundSignature;
    }

    public int getArity() {
        return this.boundSignature.getArgumentTypes().size();
    }

    public Type getTypeVariable(String variableName) {
        return FunctionBinding.getValue(this.typeVariables, variableName);
    }

    public boolean containsTypeVariable(String variableName) {
        return FunctionBinding.containsValue(this.typeVariables, variableName);
    }

    public Long getLongVariable(String variableName) {
        return FunctionBinding.getValue(this.longVariables, variableName);
    }

    public boolean containsLongVariable(String variableName) {
        return FunctionBinding.containsValue(this.longVariables, variableName);
    }

    private static <T> T getValue(Map<String, T> map, String variableName) {
        Preconditions.checkState((variableName != null ? 1 : 0) != 0, (Object)"variableName is null");
        T value = map.get(variableName);
        Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"value for variable '%s' is null", (Object)variableName);
        return value;
    }

    private static boolean containsValue(Map<String, ?> map, String variableName) {
        Preconditions.checkState((variableName != null ? 1 : 0) != 0, (Object)"variableName is null");
        return map.containsKey(variableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionBinding that = (FunctionBinding)o;
        return Objects.equals(this.functionId, that.functionId) && Objects.equals(this.boundSignature, that.boundSignature) && Objects.equals(this.typeVariables, that.typeVariables) && Objects.equals(this.longVariables, that.longVariables);
    }

    public int hashCode() {
        return Objects.hash(this.functionId, this.boundSignature, this.typeVariables, this.longVariables);
    }
}

