/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;

public class LongDecimalWithOverflowStateSerializer
implements AccumulatorStateSerializer<LongDecimalWithOverflowState> {
    private static final int SERIALIZED_SIZE = 24;

    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(LongDecimalWithOverflowState state, BlockBuilder out) {
        if (state.isNotNull()) {
            long overflow = state.getOverflow();
            long[] decimal = state.getDecimalArray();
            int offset = state.getDecimalArrayOffset();
            VarbinaryType.VARBINARY.writeSlice(out, Slices.wrappedLongArray((long[])new long[]{overflow, decimal[offset], decimal[offset + 1]}));
        } else {
            out.appendNull();
        }
    }

    public void deserialize(Block block, int index, LongDecimalWithOverflowState state) {
        if (!block.isNull(index)) {
            Slice slice = VarbinaryType.VARBINARY.getSlice(block, index);
            if (slice.length() != 24) {
                throw new IllegalStateException("Unexpected serialized state size: " + slice.length());
            }
            long overflow = slice.getLong(0);
            state.setOverflow(overflow);
            state.setNotNull();
            long[] decimal = state.getDecimalArray();
            int offset = state.getDecimalArrayOffset();
            decimal[offset] = slice.getLong(8);
            decimal[offset + 1] = slice.getLong(16);
        }
    }
}

