/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.util.Failures;

@ScalarFunction(value="at_timezone", hidden=true)
public class AtTimeZoneWithOffset {
    private AtTimeZoneWithOffset() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static long atTimeZone(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis, @SqlType(value="interval day to second") long zoneOffset) {
        return DateTimeEncoding.packDateTimeWithZone((long)DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis), (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)AtTimeZoneWithOffset.getZoneOffsetMinutes(zoneOffset)));
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone atTimeZone(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="interval day to second") long zoneOffset) {
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)timestamp.getEpochMillis(), (int)timestamp.getPicosOfMilli(), (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)AtTimeZoneWithOffset.getZoneOffsetMinutes(zoneOffset)));
    }

    private static long getZoneOffsetMinutes(long interval) {
        Failures.checkCondition(interval % 60000L == 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid time zone offset interval: interval contains seconds", new Object[0]);
        return interval / 60000L;
    }
}

