/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.connector.CatalogName;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class EmptySplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(EmptySplit.class).instanceSize();
    private final CatalogName catalogName;

    @JsonCreator
    public EmptySplit(@JsonProperty(value="catalogName") CatalogName catalogName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.catalogName.getRetainedSizeInBytes();
    }

    @JsonProperty
    public CatalogName getCatalogName() {
        return this.catalogName;
    }
}

