/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.SetOperationNodeTranslator;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import java.util.Collection;
import java.util.Objects;

public class ImplementExceptDistinctAsUnion
implements Rule<ExceptNode> {
    private static final Pattern<ExceptNode> PATTERN = Patterns.except().with(Patterns.Except.distinct().equalTo((Object)true));
    private final Metadata metadata;

    public ImplementExceptDistinctAsUnion(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<ExceptNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ExceptNode node, Captures captures, Rule.Context context) {
        SetOperationNodeTranslator translator = new SetOperationNodeTranslator(context.getSession(), this.metadata, context.getSymbolAllocator(), context.getIdAllocator());
        SetOperationNodeTranslator.TranslationResult result = translator.makeSetContainmentPlanForDistinct(node);
        ImmutableList.Builder predicatesBuilder = ImmutableList.builder();
        predicatesBuilder.add((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)result.getCountSymbols().get(0).toSymbolReference(), (Expression)new GenericLiteral("BIGINT", "1")));
        for (int i = 1; i < node.getSources().size(); ++i) {
            predicatesBuilder.add((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)result.getCountSymbols().get(i).toSymbolReference(), (Expression)new GenericLiteral("BIGINT", "0")));
        }
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), new FilterNode(context.getIdAllocator().getNextId(), result.getPlanNode(), ExpressionUtils.and((Collection<Expression>)predicatesBuilder.build())), Assignments.identity(node.getOutputSymbols())));
    }
}

