/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsProvider;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Optional;

public final class Rules {
    private Rules() {
    }

    public static Optional<PlanNodeStatsEstimate> deriveTableStatisticsForPushdown(StatsProvider statsProvider, Session session, boolean precalculateStatistics, PlanNode oldTableScanParent) {
        if (!precalculateStatistics || !SystemSessionProperties.isStatisticsPrecalculationForPushdownEnabled(session)) {
            return Optional.empty();
        }
        PlanNodeStatsEstimate statistics = statsProvider.getStats(oldTableScanParent);
        return Optional.of(statistics);
    }
}

