/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bookkeeper.client.PulsarMockBookKeeper;
import org.apache.bookkeeper.client.PulsarMockReadHandleInterceptor;
import org.apache.bookkeeper.client.api.LastConfirmedAndEntry;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.impl.LedgerEntriesImpl;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PulsarMockReadHandle
implements ReadHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarMockReadHandle.class);
    private final PulsarMockBookKeeper bk;
    private final long ledgerId;
    private final LedgerMetadata metadata;
    private final List<LedgerEntryImpl> entries;
    private final Supplier<PulsarMockReadHandleInterceptor> readHandleInterceptorSupplier;

    PulsarMockReadHandle(PulsarMockBookKeeper bk, long ledgerId, LedgerMetadata metadata, List<LedgerEntryImpl> entries, Supplier<PulsarMockReadHandleInterceptor> readHandleInterceptorSupplier) {
        this.bk = bk;
        this.ledgerId = ledgerId;
        this.metadata = metadata;
        this.entries = entries;
        this.readHandleInterceptorSupplier = readHandleInterceptorSupplier;
    }

    public CompletableFuture<LedgerEntries> readAsync(long firstEntry, long lastEntry) {
        return this.bk.getProgrammedFailure().thenComposeAsync(res -> {
            log.debug("readEntries: first={} last={} total={}", new Object[]{firstEntry, lastEntry, this.entries.size()});
            ArrayList<LedgerEntryImpl> seq = new ArrayList<LedgerEntryImpl>();
            long entryId = firstEntry;
            while (entryId <= lastEntry && entryId < (long)this.entries.size()) {
                seq.add(this.entries.get((int)entryId++).duplicate());
            }
            log.debug("Entries read: {}", seq);
            LedgerEntriesImpl ledgerEntries = LedgerEntriesImpl.create(seq);
            PulsarMockReadHandleInterceptor pulsarMockReadHandleInterceptor = this.readHandleInterceptorSupplier.get();
            if (pulsarMockReadHandleInterceptor != null) {
                return pulsarMockReadHandleInterceptor.interceptReadAsync(this.ledgerId, firstEntry, lastEntry, (LedgerEntries)ledgerEntries);
            }
            return FutureUtils.value((Object)ledgerEntries);
        });
    }

    public CompletableFuture<LedgerEntries> readUnconfirmedAsync(long firstEntry, long lastEntry) {
        return this.readAsync(firstEntry, lastEntry);
    }

    public CompletableFuture<Long> readLastAddConfirmedAsync() {
        return CompletableFuture.completedFuture(this.getLastAddConfirmed());
    }

    public CompletableFuture<Long> tryReadLastAddConfirmedAsync() {
        return this.readLastAddConfirmedAsync();
    }

    public long getLastAddConfirmed() {
        if (this.entries.isEmpty()) {
            return -1L;
        }
        return this.entries.get(this.entries.size() - 1).getEntryId();
    }

    public long getLength() {
        long length = 0L;
        for (LedgerEntryImpl entry : this.entries) {
            length += entry.getLength();
        }
        return length;
    }

    public boolean isClosed() {
        return this.metadata.isClosed();
    }

    public CompletableFuture<LastConfirmedAndEntry> readLastAddConfirmedAndEntryAsync(long entryId, long timeOutInMillis, boolean parallel) {
        CompletableFuture<LastConfirmedAndEntry> promise = new CompletableFuture<LastConfirmedAndEntry>();
        promise.completeExceptionally(new UnsupportedOperationException("Long poll not implemented"));
        return promise;
    }

    public long getId() {
        return this.ledgerId;
    }

    public CompletableFuture<Void> closeAsync() {
        return CompletableFuture.completedFuture(null);
    }

    public LedgerMetadata getLedgerMetadata() {
        return this.metadata;
    }
}

