/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl.cache;

import com.google.common.annotations.VisibleForTesting;
import io.prometheus.client.Gauge;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InflightReadsLimiter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InflightReadsLimiter.class);
    private static final Gauge PULSAR_ML_READS_BUFFER_SIZE = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_ml_reads_inflight_bytes")).help("Estimated number of bytes retained by data read from storage or cache")).register();
    private final int maxReadsInFlightAcquireQueueSize;
    private static final Gauge PULSAR_ML_READS_AVAILABLE_BUFFER_SIZE = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_ml_reads_available_inflight_bytes")).help("Available space for inflight data read from storage or cache")).register();
    private final long maxReadsInFlightSize;
    private long remainingBytes;
    private final long acquireTimeoutMillis;
    private final ScheduledExecutorService timeOutExecutor;
    private final boolean enabled;
    private final Queue<QueuedHandle> queuedHandles;
    private boolean timeoutCheckRunning = false;
    private static final Handle DISABLED = new Handle(0L, 0L, true);
    private static final Optional<Handle> DISABLED_OPTIONAL = Optional.of(DISABLED);

    public InflightReadsLimiter(long maxReadsInFlightSize, int maxReadsInFlightAcquireQueueSize, long acquireTimeoutMillis, ScheduledExecutorService timeOutExecutor) {
        this.maxReadsInFlightSize = maxReadsInFlightSize;
        this.remainingBytes = maxReadsInFlightSize;
        this.acquireTimeoutMillis = acquireTimeoutMillis;
        this.timeOutExecutor = timeOutExecutor;
        this.maxReadsInFlightAcquireQueueSize = maxReadsInFlightAcquireQueueSize;
        if (maxReadsInFlightSize > 0L) {
            this.enabled = true;
            this.queuedHandles = new ArrayDeque<QueuedHandle>();
        } else {
            this.enabled = false;
            this.queuedHandles = null;
            PULSAR_ML_READS_BUFFER_SIZE.set(-1.0);
            PULSAR_ML_READS_AVAILABLE_BUFFER_SIZE.set(-1.0);
        }
    }

    @VisibleForTesting
    public synchronized long getRemainingBytes() {
        return this.remainingBytes;
    }

    public Optional<Handle> acquire(long permits, Consumer<Handle> callback) {
        if (this.isDisabled()) {
            return DISABLED_OPTIONAL;
        }
        return this.internalAcquire(permits, callback);
    }

    private synchronized Optional<Handle> internalAcquire(long permits, Consumer<Handle> callback) {
        Handle handle = new Handle(permits, System.currentTimeMillis(), true);
        if (this.remainingBytes >= permits) {
            this.remainingBytes -= permits;
            if (log.isDebugEnabled()) {
                log.debug("acquired permits: {}, creationTime: {}, remainingBytes:{}", new Object[]{permits, handle.creationTime, this.remainingBytes});
            }
            this.updateMetrics();
            return Optional.of(handle);
        }
        if (permits > this.maxReadsInFlightSize && this.remainingBytes == this.maxReadsInFlightSize) {
            this.remainingBytes = 0L;
            if (log.isInfoEnabled()) {
                log.info("Requested permits {} exceeded maxReadsInFlightSize {}, creationTime: {}, remainingBytes:{}. Allowing request with permits set to maxReadsInFlightSize.", new Object[]{permits, this.maxReadsInFlightSize, handle.creationTime, this.remainingBytes});
            }
            this.updateMetrics();
            return Optional.of(new Handle(this.maxReadsInFlightSize, handle.creationTime, true));
        }
        if (this.queuedHandles.size() >= this.maxReadsInFlightAcquireQueueSize) {
            log.warn("Failed to queue handle for acquiring permits: {}, creationTime: {}, remainingBytes:{}, maxReadsInFlightAcquireQueueSize:{}, pending-queue-size: {}, please increase broker config managedLedgerMaxReadsInFlightPermitsAcquireQueueSize and confirm the configuration of managedLedgerMaxReadsInFlightSizeInMB and managedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis are suitable.", new Object[]{permits, handle.creationTime, this.remainingBytes, this.maxReadsInFlightAcquireQueueSize, this.queuedHandles.size()});
            return Optional.of(new Handle(0L, handle.creationTime, false));
        }
        this.queuedHandles.offer(new QueuedHandle(handle, callback));
        this.scheduleTimeOutCheck(this.acquireTimeoutMillis);
        return Optional.empty();
    }

    private synchronized void scheduleTimeOutCheck(long delayMillis) {
        if (this.acquireTimeoutMillis <= 0L) {
            return;
        }
        if (!this.timeoutCheckRunning) {
            this.timeoutCheckRunning = true;
            this.timeOutExecutor.schedule(this::timeoutCheck, delayMillis, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void timeoutCheck() {
        QueuedHandle queuedHandle;
        this.timeoutCheckRunning = false;
        long delay = 0L;
        while ((queuedHandle = this.queuedHandles.peek()) != null) {
            long age = System.currentTimeMillis() - queuedHandle.handle.creationTime;
            if (age >= this.acquireTimeoutMillis) {
                this.queuedHandles.poll();
                this.handleTimeout(queuedHandle);
                continue;
            }
            delay = this.acquireTimeoutMillis - age;
            break;
        }
        if (delay > 0L) {
            this.scheduleTimeOutCheck(delay);
        }
    }

    private void handleTimeout(QueuedHandle queuedHandle) {
        log.warn("timed out queued permits: {}, creationTime: {}, remainingBytes:{}, acquireTimeoutMillis: {}. Please review whether the BK read requests is fast enough or broker config managedLedgerMaxReadsInFlightSizeInMB and managedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis are suitable", new Object[]{queuedHandle.handle.permits, queuedHandle.handle.creationTime, this.remainingBytes, this.acquireTimeoutMillis});
        try {
            queuedHandle.callback.accept(new Handle(0L, queuedHandle.handle.creationTime, false));
        }
        catch (Exception e) {
            log.error("Error in callback of timed out queued permits: {}, creationTime: {}, remainingBytes:{}, acquireTimeoutMillis: {}", new Object[]{queuedHandle.handle.permits, queuedHandle.handle.creationTime, this.remainingBytes, this.acquireTimeoutMillis, e});
        }
    }

    public void release(Handle handle) {
        if (handle == DISABLED) {
            return;
        }
        this.internalRelease(handle);
    }

    private synchronized void internalRelease(Handle handle) {
        QueuedHandle queuedHandle;
        if (log.isDebugEnabled()) {
            log.debug("release permits: {}, creationTime: {}, remainingBytes:{}", new Object[]{handle.permits, handle.creationTime, this.getRemainingBytes()});
        }
        this.remainingBytes += handle.permits;
        while ((queuedHandle = this.queuedHandles.peek()) != null) {
            boolean timedOut;
            boolean bl = timedOut = this.acquireTimeoutMillis > 0L && System.currentTimeMillis() - queuedHandle.handle.creationTime > this.acquireTimeoutMillis;
            if (timedOut) {
                this.queuedHandles.poll();
                this.handleTimeout(queuedHandle);
                continue;
            }
            if (this.remainingBytes < queuedHandle.handle.permits && (queuedHandle.handle.permits <= this.maxReadsInFlightSize || this.remainingBytes != this.maxReadsInFlightSize)) break;
            this.queuedHandles.poll();
            this.handleQueuedHandle(queuedHandle);
        }
        this.updateMetrics();
    }

    private void handleQueuedHandle(QueuedHandle queuedHandle) {
        long permits = queuedHandle.handle.permits;
        Handle handleForCallback = queuedHandle.handle;
        if (permits > this.maxReadsInFlightSize && this.remainingBytes == this.maxReadsInFlightSize) {
            this.remainingBytes = 0L;
            if (log.isInfoEnabled()) {
                log.info("Requested permits {} exceeded maxReadsInFlightSize {}, creationTime: {}, remainingBytes:{}. Allowing request with permits set to maxReadsInFlightSize.", new Object[]{permits, this.maxReadsInFlightSize, queuedHandle.handle.creationTime, this.remainingBytes});
            }
            handleForCallback = new Handle(this.maxReadsInFlightSize, queuedHandle.handle.creationTime, true);
        } else {
            this.remainingBytes -= permits;
            if (log.isDebugEnabled()) {
                log.debug("acquired queued permits: {}, creationTime: {}, remainingBytes:{}", new Object[]{permits, queuedHandle.handle.creationTime, this.remainingBytes});
            }
        }
        try {
            queuedHandle.callback.accept(handleForCallback);
        }
        catch (Exception e) {
            log.error("Error in callback of acquired queued permits: {}, creationTime: {}, remainingBytes:{}", new Object[]{handleForCallback.permits, handleForCallback.creationTime, this.remainingBytes, e});
        }
    }

    private synchronized void updateMetrics() {
        PULSAR_ML_READS_BUFFER_SIZE.set((double)(this.maxReadsInFlightSize - this.remainingBytes));
        PULSAR_ML_READS_AVAILABLE_BUFFER_SIZE.set((double)this.remainingBytes);
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    record Handle(long permits, long creationTime, boolean success) {
    }

    record QueuedHandle(Handle handle, Consumer<Handle> callback) {
    }
}

