/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import io.trino.execution.RemoteTask;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.execution.scheduler.SplitPlacementPolicy;
import io.trino.execution.scheduler.SplitPlacementResult;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class DynamicSplitPlacementPolicy
implements SplitPlacementPolicy {
    private final NodeSelector nodeSelector;
    private final Supplier<? extends List<RemoteTask>> remoteTasks;

    public DynamicSplitPlacementPolicy(NodeSelector nodeSelector, Supplier<? extends List<RemoteTask>> remoteTasks) {
        this.nodeSelector = Objects.requireNonNull(nodeSelector, "nodeSelector is null");
        this.remoteTasks = Objects.requireNonNull(remoteTasks, "remoteTasks is null");
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits) {
        return this.nodeSelector.computeAssignments(splits, this.remoteTasks.get());
    }

    @Override
    public void lockDownNodes() {
        this.nodeSelector.lockDownNodes();
    }

    @Override
    public List<InternalNode> allNodes() {
        return this.nodeSelector.allNodes();
    }
}

