/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.trino.Session;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.ParameterRewriter;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class AbstractPropertyManager<K> {
    protected final ConcurrentMap<K, Map<String, PropertyMetadata<?>>> connectorProperties = new ConcurrentHashMap();
    private final String propertyType;
    private final ErrorCodeSupplier propertyError;

    protected AbstractPropertyManager(String propertyType, ErrorCodeSupplier propertyError) {
        Objects.requireNonNull(propertyType, "propertyType is null");
        this.propertyType = propertyType;
        this.propertyError = Objects.requireNonNull(propertyError, "propertyError is null");
    }

    protected final void doAddProperties(K propertiesKey, List<PropertyMetadata<?>> properties) {
        Objects.requireNonNull(propertiesKey, "propertiesKey is null");
        Objects.requireNonNull(properties, "properties is null");
        ImmutableMap propertiesByName = Maps.uniqueIndex(properties, PropertyMetadata::getName);
        Preconditions.checkState((this.connectorProperties.putIfAbsent(propertiesKey, (Map<String, PropertyMetadata<?>>)propertiesByName) == null ? 1 : 0) != 0, (String)"Properties for key %s are already registered", propertiesKey);
    }

    protected final void doRemoveProperties(K propertiesKey) {
        this.connectorProperties.remove(propertiesKey);
    }

    protected final Map<String, Object> doGetProperties(K propertiesKey, String catalogNameForDiagnostics, Map<String, Expression> sqlPropertyValues, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters, boolean setDefaultProperties) {
        Map supportedProperties = (Map)this.connectorProperties.get(propertiesKey);
        if (supportedProperties == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, this.formatPropertiesKeyForMessage(catalogNameForDiagnostics, propertiesKey) + " not found");
        }
        ImmutableMap.Builder properties = ImmutableMap.builder();
        for (Map.Entry<String, Expression> sqlProperty : sqlPropertyValues.entrySet()) {
            Object value;
            Object sqlObjectValue;
            String propertyName = sqlProperty.getKey().toLowerCase(Locale.ENGLISH);
            PropertyMetadata property = (PropertyMetadata)supportedProperties.get(propertyName);
            if (property == null) {
                throw new TrinoException(this.propertyError, String.format("%s does not support %s property '%s'", this.formatPropertiesKeyForMessage(catalogNameForDiagnostics, propertiesKey), this.propertyType, propertyName));
            }
            try {
                sqlObjectValue = this.evaluatePropertyValue(sqlProperty.getValue(), property.getSqlType(), session, plannerContext, accessControl, parameters);
            }
            catch (TrinoException e) {
                throw new TrinoException(this.propertyError, String.format("Invalid value for %s property '%s': Cannot convert [%s] to %s", this.propertyType, property.getName(), sqlProperty.getValue(), property.getSqlType()), (Throwable)e);
            }
            try {
                value = property.decode(sqlObjectValue);
            }
            catch (Exception e) {
                throw new TrinoException(this.propertyError, String.format("Unable to set %s property '%s' to [%s]: %s", this.propertyType, property.getName(), sqlProperty.getValue(), e.getMessage()), (Throwable)e);
            }
            properties.put((Object)property.getName(), value);
        }
        ImmutableMap userSpecifiedProperties = properties.build();
        if (!setDefaultProperties) {
            return properties.build();
        }
        for (PropertyMetadata propertyMetadata : supportedProperties.values()) {
            Object value;
            if (userSpecifiedProperties.containsKey(propertyMetadata.getName()) || (value = propertyMetadata.getDefaultValue()) == null) continue;
            properties.put((Object)propertyMetadata.getName(), value);
        }
        return properties.build();
    }

    protected final Map<K, Map<String, PropertyMetadata<?>>> doGetAllProperties() {
        return ImmutableMap.copyOf(this.connectorProperties);
    }

    private Object evaluatePropertyValue(Expression expression, Type expectedType, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(parameters), (Expression)expression);
        Object value = ExpressionInterpreter.evaluateConstantExpression(rewritten, expectedType, plannerContext, session, accessControl, parameters);
        BlockBuilder blockBuilder = expectedType.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue((Type)expectedType, (BlockBuilder)blockBuilder, (Object)value);
        Object objectValue = expectedType.getObjectValue(session.toConnectorSession(), (Block)blockBuilder, 0);
        if (objectValue == null) {
            throw new TrinoException(this.propertyError, String.format("Invalid null value for %s property", this.propertyType));
        }
        return objectValue;
    }

    protected abstract String formatPropertiesKeyForMessage(String var1, K var2);
}

