/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.ExceededMemoryLimitException;
import io.trino.memory.context.MemoryAllocationValidator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class TaskAllocationValidator
implements MemoryAllocationValidator {
    private final long limitBytes;
    @GuardedBy(value="this")
    private long usedBytes;
    @GuardedBy(value="this")
    private final Map<String, Long> taggedAllocations = new HashMap<String, Long>();

    public TaskAllocationValidator(DataSize memoryLimit) {
        this.limitBytes = Objects.requireNonNull(memoryLimit, "memoryLimit is null").toBytes();
    }

    public synchronized void reserveMemory(String allocationTag, long delta) {
        if (this.usedBytes + delta > this.limitBytes) {
            Verify.verify((delta > 0L ? 1 : 0) != 0, (String)"exceeded limit with negative delta (%s); usedBytes=%s, limitBytes=%s", (Object)delta, (Object)this.usedBytes, (Object)this.limitBytes);
            this.raiseLimitExceededFailure(allocationTag, delta);
        }
        this.usedBytes += delta;
        this.taggedAllocations.merge(allocationTag, delta, Long::sum);
    }

    private synchronized void raiseLimitExceededFailure(String currentAllocationTag, long currentAllocationDelta) {
        HashMap<String, Long> tmpTaggedAllocations = new HashMap<String, Long>(this.taggedAllocations);
        tmpTaggedAllocations.merge(currentAllocationTag, currentAllocationDelta, Long::sum);
        String topConsumers = ((ImmutableMap)tmpTaggedAllocations.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(3L).filter(e -> (Long)e.getValue() >= 0L).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> DataSize.succinctBytes((long)((Long)e.getValue()))))).toString();
        String additionalInfo = String.format("Allocated: %s, Delta: %s, Top Consumers: %s", DataSize.succinctBytes((long)this.usedBytes), DataSize.succinctBytes((long)currentAllocationDelta), topConsumers);
        throw ExceededMemoryLimitException.exceededTaskMemoryLimit(DataSize.succinctBytes((long)this.limitBytes), additionalInfo);
    }

    public synchronized boolean tryReserveMemory(String allocationTag, long delta) {
        if (this.usedBytes + delta > this.limitBytes) {
            Verify.verify((delta > 0L ? 1 : 0) != 0, (String)"exceeded limit with negative delta (%s); usedBytes=%s, limitBytes=%s", (Object)delta, (Object)this.usedBytes, (Object)this.limitBytes);
            return false;
        }
        this.usedBytes += delta;
        return true;
    }
}

