/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.shard;

import io.oxia.client.ProtoUtil;
import io.oxia.proto.Int32HashRange;
import lombok.NonNull;

public record HashRange(long minInclusive, long maxInclusive) {
    public HashRange {
        HashRange.checkHash(minInclusive);
        HashRange.checkHash(maxInclusive);
        if (maxInclusive < minInclusive) {
            throw new IllegalArgumentException("Invalid HashRange: [" + minInclusive + ":" + maxInclusive + "]");
        }
    }

    private static void checkHash(long hash) {
        if (hash < 0L) {
            throw new IllegalArgumentException("Invalid HashRange bound: " + hash);
        }
    }

    public boolean overlaps(@NonNull HashRange other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return this.minInclusive <= other.maxInclusive && this.maxInclusive >= other.minInclusive;
    }

    @NonNull
    static HashRange fromProto(@NonNull Int32HashRange p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        return new HashRange(ProtoUtil.uint32ToLong(p.getMinHashInclusive()), ProtoUtil.uint32ToLong(p.getMaxHashInclusive()));
    }
}

