/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.common.api.proto.LightProtoCodec;

public final class CommandLookupTopic {
    private String topic;
    private int _topicBufferIdx = -1;
    private int _topicBufferLen = -1;
    private static final int _TOPIC_FIELD_NUMBER = 1;
    private static final int _TOPIC_TAG = 10;
    private static final int _TOPIC_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private static final int _TOPIC_MASK = 1;
    private long requestId;
    private static final int _REQUEST_ID_FIELD_NUMBER = 2;
    private static final int _REQUEST_ID_TAG = 16;
    private static final int _REQUEST_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _REQUEST_ID_MASK = 2;
    private boolean authoritative = false;
    private static final int _AUTHORITATIVE_FIELD_NUMBER = 3;
    private static final int _AUTHORITATIVE_TAG = 24;
    private static final int _AUTHORITATIVE_TAG_SIZE = LightProtoCodec.computeVarIntSize(24);
    private static final int _AUTHORITATIVE_MASK = 4;
    private String originalPrincipal;
    private int _originalPrincipalBufferIdx = -1;
    private int _originalPrincipalBufferLen = -1;
    private static final int _ORIGINAL_PRINCIPAL_FIELD_NUMBER = 4;
    private static final int _ORIGINAL_PRINCIPAL_TAG = 34;
    private static final int _ORIGINAL_PRINCIPAL_TAG_SIZE = LightProtoCodec.computeVarIntSize(34);
    private static final int _ORIGINAL_PRINCIPAL_MASK = 8;
    private String originalAuthData;
    private int _originalAuthDataBufferIdx = -1;
    private int _originalAuthDataBufferLen = -1;
    private static final int _ORIGINAL_AUTH_DATA_FIELD_NUMBER = 5;
    private static final int _ORIGINAL_AUTH_DATA_TAG = 42;
    private static final int _ORIGINAL_AUTH_DATA_TAG_SIZE = LightProtoCodec.computeVarIntSize(42);
    private static final int _ORIGINAL_AUTH_DATA_MASK = 16;
    private String originalAuthMethod;
    private int _originalAuthMethodBufferIdx = -1;
    private int _originalAuthMethodBufferLen = -1;
    private static final int _ORIGINAL_AUTH_METHOD_FIELD_NUMBER = 6;
    private static final int _ORIGINAL_AUTH_METHOD_TAG = 50;
    private static final int _ORIGINAL_AUTH_METHOD_TAG_SIZE = LightProtoCodec.computeVarIntSize(50);
    private static final int _ORIGINAL_AUTH_METHOD_MASK = 32;
    private String advertisedListenerName;
    private int _advertisedListenerNameBufferIdx = -1;
    private int _advertisedListenerNameBufferLen = -1;
    private static final int _ADVERTISED_LISTENER_NAME_FIELD_NUMBER = 7;
    private static final int _ADVERTISED_LISTENER_NAME_TAG = 58;
    private static final int _ADVERTISED_LISTENER_NAME_TAG_SIZE = LightProtoCodec.computeVarIntSize(58);
    private static final int _ADVERTISED_LISTENER_NAME_MASK = 64;
    private List<KeyValue> properties = null;
    private int _propertiesCount = 0;
    private static final int _PROPERTIES_FIELD_NUMBER = 8;
    private static final int _PROPERTIES_TAG = 66;
    private static final int _PROPERTIES_TAG_SIZE = LightProtoCodec.computeVarIntSize(66);
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 3;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasTopic() {
        return (this._bitField0 & 1) != 0;
    }

    public String getTopic() {
        if (!this.hasTopic()) {
            throw new IllegalStateException("Field 'topic' is not set");
        }
        if (this.topic == null) {
            this.topic = LightProtoCodec.readString(this._parsedBuffer, this._topicBufferIdx, this._topicBufferLen);
        }
        return this.topic;
    }

    public CommandLookupTopic setTopic(String topic) {
        this.topic = topic;
        this._bitField0 |= 1;
        this._topicBufferIdx = -1;
        this._topicBufferLen = LightProtoCodec.computeStringUTF8Size(topic);
        this._cachedSize = -1;
        return this;
    }

    public CommandLookupTopic clearTopic() {
        this._bitField0 &= 0xFFFFFFFE;
        this.topic = null;
        this._topicBufferIdx = -1;
        this._topicBufferLen = -1;
        return this;
    }

    public boolean hasRequestId() {
        return (this._bitField0 & 2) != 0;
    }

    public long getRequestId() {
        if (!this.hasRequestId()) {
            throw new IllegalStateException("Field 'request_id' is not set");
        }
        return this.requestId;
    }

    public CommandLookupTopic setRequestId(long requestId) {
        this.requestId = requestId;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public CommandLookupTopic clearRequestId() {
        this._bitField0 &= 0xFFFFFFFD;
        return this;
    }

    public boolean hasAuthoritative() {
        return (this._bitField0 & 4) != 0;
    }

    public boolean isAuthoritative() {
        return this.authoritative;
    }

    public CommandLookupTopic setAuthoritative(boolean authoritative) {
        this.authoritative = authoritative;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public CommandLookupTopic clearAuthoritative() {
        this._bitField0 &= 0xFFFFFFFB;
        this.authoritative = false;
        return this;
    }

    public boolean hasOriginalPrincipal() {
        return (this._bitField0 & 8) != 0;
    }

    public String getOriginalPrincipal() {
        if (!this.hasOriginalPrincipal()) {
            throw new IllegalStateException("Field 'original_principal' is not set");
        }
        if (this.originalPrincipal == null) {
            this.originalPrincipal = LightProtoCodec.readString(this._parsedBuffer, this._originalPrincipalBufferIdx, this._originalPrincipalBufferLen);
        }
        return this.originalPrincipal;
    }

    public CommandLookupTopic setOriginalPrincipal(String originalPrincipal) {
        this.originalPrincipal = originalPrincipal;
        this._bitField0 |= 8;
        this._originalPrincipalBufferIdx = -1;
        this._originalPrincipalBufferLen = LightProtoCodec.computeStringUTF8Size(originalPrincipal);
        this._cachedSize = -1;
        return this;
    }

    public CommandLookupTopic clearOriginalPrincipal() {
        this._bitField0 &= 0xFFFFFFF7;
        this.originalPrincipal = null;
        this._originalPrincipalBufferIdx = -1;
        this._originalPrincipalBufferLen = -1;
        return this;
    }

    public boolean hasOriginalAuthData() {
        return (this._bitField0 & 0x10) != 0;
    }

    public String getOriginalAuthData() {
        if (!this.hasOriginalAuthData()) {
            throw new IllegalStateException("Field 'original_auth_data' is not set");
        }
        if (this.originalAuthData == null) {
            this.originalAuthData = LightProtoCodec.readString(this._parsedBuffer, this._originalAuthDataBufferIdx, this._originalAuthDataBufferLen);
        }
        return this.originalAuthData;
    }

    public CommandLookupTopic setOriginalAuthData(String originalAuthData) {
        this.originalAuthData = originalAuthData;
        this._bitField0 |= 0x10;
        this._originalAuthDataBufferIdx = -1;
        this._originalAuthDataBufferLen = LightProtoCodec.computeStringUTF8Size(originalAuthData);
        this._cachedSize = -1;
        return this;
    }

    public CommandLookupTopic clearOriginalAuthData() {
        this._bitField0 &= 0xFFFFFFEF;
        this.originalAuthData = null;
        this._originalAuthDataBufferIdx = -1;
        this._originalAuthDataBufferLen = -1;
        return this;
    }

    public boolean hasOriginalAuthMethod() {
        return (this._bitField0 & 0x20) != 0;
    }

    public String getOriginalAuthMethod() {
        if (!this.hasOriginalAuthMethod()) {
            throw new IllegalStateException("Field 'original_auth_method' is not set");
        }
        if (this.originalAuthMethod == null) {
            this.originalAuthMethod = LightProtoCodec.readString(this._parsedBuffer, this._originalAuthMethodBufferIdx, this._originalAuthMethodBufferLen);
        }
        return this.originalAuthMethod;
    }

    public CommandLookupTopic setOriginalAuthMethod(String originalAuthMethod) {
        this.originalAuthMethod = originalAuthMethod;
        this._bitField0 |= 0x20;
        this._originalAuthMethodBufferIdx = -1;
        this._originalAuthMethodBufferLen = LightProtoCodec.computeStringUTF8Size(originalAuthMethod);
        this._cachedSize = -1;
        return this;
    }

    public CommandLookupTopic clearOriginalAuthMethod() {
        this._bitField0 &= 0xFFFFFFDF;
        this.originalAuthMethod = null;
        this._originalAuthMethodBufferIdx = -1;
        this._originalAuthMethodBufferLen = -1;
        return this;
    }

    public boolean hasAdvertisedListenerName() {
        return (this._bitField0 & 0x40) != 0;
    }

    public String getAdvertisedListenerName() {
        if (!this.hasAdvertisedListenerName()) {
            throw new IllegalStateException("Field 'advertised_listener_name' is not set");
        }
        if (this.advertisedListenerName == null) {
            this.advertisedListenerName = LightProtoCodec.readString(this._parsedBuffer, this._advertisedListenerNameBufferIdx, this._advertisedListenerNameBufferLen);
        }
        return this.advertisedListenerName;
    }

    public CommandLookupTopic setAdvertisedListenerName(String advertisedListenerName) {
        this.advertisedListenerName = advertisedListenerName;
        this._bitField0 |= 0x40;
        this._advertisedListenerNameBufferIdx = -1;
        this._advertisedListenerNameBufferLen = LightProtoCodec.computeStringUTF8Size(advertisedListenerName);
        this._cachedSize = -1;
        return this;
    }

    public CommandLookupTopic clearAdvertisedListenerName() {
        this._bitField0 &= 0xFFFFFFBF;
        this.advertisedListenerName = null;
        this._advertisedListenerNameBufferIdx = -1;
        this._advertisedListenerNameBufferLen = -1;
        return this;
    }

    public int getPropertiesCount() {
        return this._propertiesCount;
    }

    public KeyValue getPropertyAt(int idx) {
        if (idx < 0 || idx >= this._propertiesCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._propertiesCount + ") for field 'properties'");
        }
        return this.properties.get(idx);
    }

    public List<KeyValue> getPropertiesList() {
        if (this._propertiesCount == 0) {
            return Collections.emptyList();
        }
        return this.properties.subList(0, this._propertiesCount);
    }

    public KeyValue addProperty() {
        if (this.properties == null) {
            this.properties = new ArrayList<KeyValue>();
        }
        if (this.properties.size() == this._propertiesCount) {
            this.properties.add(new KeyValue());
        }
        this._cachedSize = -1;
        return this.properties.get(this._propertiesCount++);
    }

    public CommandLookupTopic addAllProperties(Iterable<KeyValue> properties) {
        for (KeyValue _o : properties) {
            this.addProperty().copyFrom(_o);
        }
        return this;
    }

    public CommandLookupTopic clearProperties() {
        for (int i = 0; i < this._propertiesCount; ++i) {
            this.properties.get(i).clear();
        }
        this._propertiesCount = 0;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 10);
        LightProtoCodec.writeVarInt(_b, this._topicBufferLen);
        if (this._topicBufferIdx == -1) {
            LightProtoCodec.writeString(_b, this.topic, this._topicBufferLen);
        } else {
            this._parsedBuffer.getBytes(this._topicBufferIdx, _b, this._topicBufferLen);
        }
        LightProtoCodec.writeVarInt(_b, 16);
        LightProtoCodec.writeVarInt64(_b, this.requestId);
        if (this.hasAuthoritative()) {
            LightProtoCodec.writeVarInt(_b, 24);
            _b.writeBoolean(this.authoritative);
        }
        if (this.hasOriginalPrincipal()) {
            LightProtoCodec.writeVarInt(_b, 34);
            LightProtoCodec.writeVarInt(_b, this._originalPrincipalBufferLen);
            if (this._originalPrincipalBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.originalPrincipal, this._originalPrincipalBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._originalPrincipalBufferIdx, _b, this._originalPrincipalBufferLen);
            }
        }
        if (this.hasOriginalAuthData()) {
            LightProtoCodec.writeVarInt(_b, 42);
            LightProtoCodec.writeVarInt(_b, this._originalAuthDataBufferLen);
            if (this._originalAuthDataBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.originalAuthData, this._originalAuthDataBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._originalAuthDataBufferIdx, _b, this._originalAuthDataBufferLen);
            }
        }
        if (this.hasOriginalAuthMethod()) {
            LightProtoCodec.writeVarInt(_b, 50);
            LightProtoCodec.writeVarInt(_b, this._originalAuthMethodBufferLen);
            if (this._originalAuthMethodBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.originalAuthMethod, this._originalAuthMethodBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._originalAuthMethodBufferIdx, _b, this._originalAuthMethodBufferLen);
            }
        }
        if (this.hasAdvertisedListenerName()) {
            LightProtoCodec.writeVarInt(_b, 58);
            LightProtoCodec.writeVarInt(_b, this._advertisedListenerNameBufferLen);
            if (this._advertisedListenerNameBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.advertisedListenerName, this._advertisedListenerNameBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._advertisedListenerNameBufferIdx, _b, this._advertisedListenerNameBufferLen);
            }
        }
        for (int i = 0; i < this._propertiesCount; ++i) {
            KeyValue _item = this.properties.get(i);
            LightProtoCodec.writeVarInt(_b, 66);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _TOPIC_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._topicBufferLen);
        _size += this._topicBufferLen;
        _size += _REQUEST_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.requestId);
        if (this.hasAuthoritative()) {
            _size += _AUTHORITATIVE_TAG_SIZE;
            ++_size;
        }
        if (this.hasOriginalPrincipal()) {
            _size += _ORIGINAL_PRINCIPAL_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._originalPrincipalBufferLen);
            _size += this._originalPrincipalBufferLen;
        }
        if (this.hasOriginalAuthData()) {
            _size += _ORIGINAL_AUTH_DATA_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._originalAuthDataBufferLen);
            _size += this._originalAuthDataBufferLen;
        }
        if (this.hasOriginalAuthMethod()) {
            _size += _ORIGINAL_AUTH_METHOD_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._originalAuthMethodBufferLen);
            _size += this._originalAuthMethodBufferLen;
        }
        if (this.hasAdvertisedListenerName()) {
            _size += _ADVERTISED_LISTENER_NAME_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._advertisedListenerNameBufferLen);
            _size += this._advertisedListenerNameBufferLen;
        }
        for (int i = 0; i < this._propertiesCount; ++i) {
            KeyValue _item = this.properties.get(i);
            _size += _PROPERTIES_TAG_SIZE;
            int MsgsizeProperties = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeProperties) + MsgsizeProperties;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block10: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    this._bitField0 |= 1;
                    this._topicBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._topicBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._topicBufferLen);
                    continue block10;
                }
                case 16: {
                    this._bitField0 |= 2;
                    this.requestId = LightProtoCodec.readVarInt64(_buffer);
                    continue block10;
                }
                case 24: {
                    this._bitField0 |= 4;
                    this.authoritative = LightProtoCodec.readVarInt(_buffer) == 1;
                    continue block10;
                }
                case 34: {
                    this._bitField0 |= 8;
                    this._originalPrincipalBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._originalPrincipalBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._originalPrincipalBufferLen);
                    continue block10;
                }
                case 42: {
                    this._bitField0 |= 0x10;
                    this._originalAuthDataBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._originalAuthDataBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._originalAuthDataBufferLen);
                    continue block10;
                }
                case 50: {
                    this._bitField0 |= 0x20;
                    this._originalAuthMethodBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._originalAuthMethodBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._originalAuthMethodBufferLen);
                    continue block10;
                }
                case 58: {
                    this._bitField0 |= 0x40;
                    this._advertisedListenerNameBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._advertisedListenerNameBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._advertisedListenerNameBufferLen);
                    continue block10;
                }
                case 66: {
                    int _propertiesSize = LightProtoCodec.readVarInt(_buffer);
                    this.addProperty().parseFrom(_buffer, _propertiesSize);
                    continue block10;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 3) != 3) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public CommandLookupTopic clear() {
        this.topic = null;
        this._topicBufferIdx = -1;
        this._topicBufferLen = -1;
        this.authoritative = false;
        this.originalPrincipal = null;
        this._originalPrincipalBufferIdx = -1;
        this._originalPrincipalBufferLen = -1;
        this.originalAuthData = null;
        this._originalAuthDataBufferIdx = -1;
        this._originalAuthDataBufferLen = -1;
        this.originalAuthMethod = null;
        this._originalAuthMethodBufferIdx = -1;
        this._originalAuthMethodBufferLen = -1;
        this.advertisedListenerName = null;
        this._advertisedListenerNameBufferIdx = -1;
        this._advertisedListenerNameBufferLen = -1;
        for (int i = 0; i < this._propertiesCount; ++i) {
            this.properties.get(i).clear();
        }
        this._propertiesCount = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public CommandLookupTopic copyFrom(CommandLookupTopic _other) {
        this._cachedSize = -1;
        if (_other.hasTopic()) {
            this.setTopic(_other.getTopic());
        }
        if (_other.hasRequestId()) {
            this.setRequestId(_other.requestId);
        }
        if (_other.hasAuthoritative()) {
            this.setAuthoritative(_other.authoritative);
        }
        if (_other.hasOriginalPrincipal()) {
            this.setOriginalPrincipal(_other.getOriginalPrincipal());
        }
        if (_other.hasOriginalAuthData()) {
            this.setOriginalAuthData(_other.getOriginalAuthData());
        }
        if (_other.hasOriginalAuthMethod()) {
            this.setOriginalAuthMethod(_other.getOriginalAuthMethod());
        }
        if (_other.hasAdvertisedListenerName()) {
            this.setAdvertisedListenerName(_other.getAdvertisedListenerName());
        }
        for (int i = 0; i < _other.getPropertiesCount(); ++i) {
            this.addProperty().copyFrom(_other.getPropertyAt(i));
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a);
        this.parseFrom(b, b.readableBytes());
    }
}

