/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractExceptionHandler {
    protected static final String CONTINUE_ON_ERROR_PROPERTY_NAME = "qpid.broker.exceptionHandler.continue";

    protected String getMessage(boolean continueOnError) {
        return continueOnError ? "# Forced to continue by JVM setting 'qpid.broker.exceptionHandler.continue'" : "# Exiting";
    }

    protected void printDiagnostic(Thread thread, Throwable throwable, boolean continueOnError) {
        System.err.println("########################################################################");
        System.err.println("#");
        System.err.print("# Unhandled Exception ");
        System.err.print(throwable.toString());
        System.err.print(" in Thread ");
        System.err.println(thread.getName());
        System.err.println("#");
        System.err.println(this.getMessage(continueOnError));
        System.err.println("#");
        System.err.println("########################################################################");
        throwable.printStackTrace(System.err);
    }

    protected void logError(Throwable throwable, boolean continueOnError) {
        Logger logger = LoggerFactory.getLogger((String)"org.apache.qpid.server.Main");
        String message = "Uncaught exception, " + (continueOnError ? "continuing." : "shutting down.");
        logger.error(message, throwable);
    }
}

