/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQProtocolVersionException;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.HeartbeatBody;
import org.apache.qpid.framing.MethodProcessor;
import org.apache.qpid.framing.ProtocolInitiation;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.util.ByteBufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQDecoder<T extends MethodProcessor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQDecoder.class);
    public static final int FRAME_HEADER_SIZE = 7;
    private final T _methodProcessor;
    private ProtocolInitiation.Decoder _piDecoder = new ProtocolInitiation.Decoder();
    private boolean _expectProtocolInitiation;
    private boolean _firstRead = true;
    public static final int FRAME_MIN_SIZE = 4096;
    private int _maxFrameSize = 4096;

    protected AMQDecoder(boolean expectProtocolInitiation, T methodProcessor) {
        this._expectProtocolInitiation = expectProtocolInitiation;
        this._methodProcessor = methodProcessor;
    }

    public void setExpectProtocolInitiation(boolean expectProtocolInitiation) {
        this._expectProtocolInitiation = expectProtocolInitiation;
    }

    public void setMaxFrameSize(int frameMax) {
        this._maxFrameSize = frameMax;
    }

    public T getMethodProcessor() {
        return this._methodProcessor;
    }

    protected final int decode(ByteBuffer buf) throws AMQFrameDecodingException {
        if (this._firstRead && buf.hasRemaining()) {
            this._firstRead = false;
            if (!this._expectProtocolInitiation && (buf.get(buf.position()) & 0xFF) > 8) {
                this._expectProtocolInitiation = true;
            }
        }
        int required = 0;
        while (required == 0) {
            if (!this._expectProtocolInitiation) {
                required = this.processAMQPFrames(buf);
                continue;
            }
            required = this._piDecoder.decodable(buf);
            if (required != 0) continue;
            this._methodProcessor.receiveProtocolHeader(new ProtocolInitiation(buf));
        }
        return buf.hasRemaining() ? required : 0;
    }

    protected int processAMQPFrames(ByteBuffer buf) throws AMQFrameDecodingException {
        int required = this.decodable(buf);
        if (required == 0) {
            this.processInput(buf);
        }
        return required;
    }

    protected int decodable(ByteBuffer in) throws AMQFrameDecodingException {
        int remainingAfterAttributes = in.remaining() - 7;
        if (remainingAfterAttributes < 0) {
            return -remainingAfterAttributes;
        }
        long bodySize = (long)in.getInt(in.position() + 3) & 0xFFFFFFFFL;
        if (bodySize > (long)this._maxFrameSize) {
            throw new AMQFrameDecodingException("Incoming frame size of " + bodySize + " is larger than negotiated maximum of  " + this._maxFrameSize);
        }
        long required = 1L + bodySize - (long)remainingAfterAttributes;
        return required > 0L ? (int)required : 0;
    }

    protected void processInput(ByteBuffer in) throws AMQFrameDecodingException, AMQProtocolVersionException {
        byte type = in.get();
        int channel = ByteBufferUtils.getUnsignedShort(in);
        long bodySize = ByteBufferUtils.getUnsignedInt(in);
        if (channel < 0 || bodySize < 0L) {
            throw new AMQFrameDecodingException("Undecodable frame: type = " + type + " channel = " + channel + " bodySize = " + bodySize);
        }
        this.processFrame(channel, type, bodySize, in);
        byte marker = in.get();
        if ((marker & 0xFF) != 206) {
            throw new AMQFrameDecodingException("End of frame marker not found. Read " + marker + " length=" + bodySize + " type=" + type);
        }
    }

    protected void processFrame(int channel, byte type, long bodySize, ByteBuffer in) throws AMQFrameDecodingException {
        switch (type) {
            case 1: {
                this.processMethod(channel, in);
                break;
            }
            case 2: {
                ContentHeaderBody.process(in, this._methodProcessor.getChannelMethodProcessor(channel), bodySize);
                break;
            }
            case 3: {
                ContentBody.process(in, this._methodProcessor.getChannelMethodProcessor(channel), bodySize);
                break;
            }
            case 8: {
                HeartbeatBody.process(channel, in, this._methodProcessor, bodySize);
                break;
            }
            default: {
                throw new AMQFrameDecodingException("Unsupported frame type: " + type);
            }
        }
    }

    abstract void processMethod(int var1, ByteBuffer var2) throws AMQFrameDecodingException;

    AMQFrameDecodingException newUnknownMethodException(int classId, int methodId, ProtocolVersion protocolVersion) {
        return new AMQFrameDecodingException(503, "Method " + methodId + " unknown in AMQP version " + protocolVersion + " (while trying to decode class " + classId + " method " + methodId + ".", null);
    }
}

