/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jndi;

import java.net.URISyntaxException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.PooledConnectionFactory;
import org.apache.qpid.messaging.Address;
import org.apache.qpid.url.AMQBindingURL;
import org.apache.qpid.url.URLSyntaxException;

public class ObjectFactory
implements javax.naming.spi.ObjectFactory {
    @Override
    public Object getObjectInstance(Object object, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            String referenceClassName = reference.getClassName();
            if (referenceClassName.equals(AMQConnectionFactory.class.getName())) {
                return this.createAMQConnectionFactory(reference);
            }
            if (referenceClassName.equals(PooledConnectionFactory.class.getName())) {
                return this.createPooledConnectionFactory(reference);
            }
            if (referenceClassName.equals(AMQConnection.class.getName())) {
                return this.createAMQConnection(reference);
            }
            if (referenceClassName.equals(AMQQueue.class.getName())) {
                return this.createAMQQueue(reference);
            }
            if (referenceClassName.equals(AMQTopic.class.getName())) {
                return this.createAMQTopic(reference);
            }
        }
        return null;
    }

    private PooledConnectionFactory createPooledConnectionFactory(Reference reference) throws URLSyntaxException {
        Object connectionURL = this.getRefAddressContent(reference, "connectionURL");
        if (connectionURL instanceof String) {
            Object connectionTimeout;
            PooledConnectionFactory connectionFactory = new PooledConnectionFactory();
            connectionFactory.setConnectionURLString(String.valueOf(connectionURL));
            Object maxPoolSize = this.getRefAddressContent(reference, "maxPoolSize");
            if (maxPoolSize != null) {
                connectionFactory.setMaxPoolSize(maxPoolSize instanceof Number ? ((Number)maxPoolSize).intValue() : Integer.parseInt(String.valueOf(maxPoolSize)));
            }
            if ((connectionTimeout = this.getRefAddressContent(reference, "connectionTimeout")) != null) {
                connectionFactory.setConnectionTimeout(connectionTimeout instanceof Number ? ((Number)connectionTimeout).longValue() : Long.parseLong(String.valueOf(connectionTimeout)));
            }
            return connectionFactory;
        }
        return null;
    }

    private AMQConnection createAMQConnection(Reference reference) throws URLSyntaxException, QpidException {
        Object connectionURL = this.getRefAddressContent(reference, "connectionURL");
        if (connectionURL == null) {
            connectionURL = this.getRefAddressContent(reference, AMQConnection.class.getName());
        }
        if (connectionURL instanceof String) {
            return new AMQConnection((String)connectionURL);
        }
        return null;
    }

    private AMQTopic createAMQTopic(Reference reference) throws URISyntaxException {
        return (AMQTopic)this.createAMQDestination(reference, AMQTopic.class);
    }

    private AMQQueue createAMQQueue(Reference reference) throws URISyntaxException {
        return (AMQQueue)this.createAMQDestination(reference, AMQQueue.class);
    }

    private AMQConnectionFactory createAMQConnectionFactory(Reference reference) throws URLSyntaxException {
        Object connectionURL = this.getRefAddressContent(reference, "connectionURL");
        if (connectionURL == null) {
            connectionURL = this.getRefAddressContent(reference, AMQConnectionFactory.class.getName());
        }
        if (connectionURL instanceof String) {
            return new AMQConnectionFactory((String)connectionURL);
        }
        return null;
    }

    private Object getRefAddressContent(Reference reference, String addressType) {
        RefAddr refAddr = reference.get(addressType);
        if (refAddr != null) {
            return refAddr.getContent();
        }
        return null;
    }

    private AMQDestination createAMQDestination(Reference reference, Class<? extends AMQDestination> destinationClass) throws URISyntaxException {
        AMQDestination.DestSyntax addressSyntax = AMQDestination.DestSyntax.ADDR;
        Object address = this.getRefAddressContent(reference, "address");
        if (address == null && (address = this.getRefAddressContent(reference, destinationClass.getName())) instanceof String) {
            addressSyntax = AMQDestination.DestSyntax.BURL;
        }
        if (address instanceof String) {
            String addressString = (String)address;
            if (addressString.startsWith(AMQDestination.DestSyntax.BURL.asPrefix())) {
                addressSyntax = AMQDestination.DestSyntax.BURL;
                addressString = addressString.substring(AMQDestination.DestSyntax.BURL.asPrefix().length());
            } else if (addressString.startsWith(AMQDestination.DestSyntax.ADDR.asPrefix())) {
                addressSyntax = AMQDestination.DestSyntax.ADDR;
                addressString = addressString.substring(AMQDestination.DestSyntax.ADDR.asPrefix().length());
            }
            return this.createAMQDestination(destinationClass, addressSyntax, addressString);
        }
        return null;
    }

    private AMQDestination createAMQDestination(Class<? extends AMQDestination> destinationClass, AMQDestination.DestSyntax addressSyntax, String addressString) throws URISyntaxException {
        if (destinationClass == AMQQueue.class) {
            if (addressSyntax == AMQDestination.DestSyntax.ADDR) {
                return new AMQQueue(Address.parse(addressString));
            }
            return new AMQQueue(new AMQBindingURL(addressString));
        }
        if (destinationClass == AMQTopic.class) {
            if (addressSyntax == AMQDestination.DestSyntax.ADDR) {
                return new AMQTopic(Address.parse(addressString));
            }
            return new AMQTopic(new AMQBindingURL(addressString));
        }
        throw new IllegalStateException("Unsupported destination " + destinationClass);
    }
}

