/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.io;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.ExceptionHandlingByteBufferReceiver;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.NetworkConnection;
import org.apache.qpid.transport.network.TransportActivity;
import org.apache.qpid.transport.network.io.IdleTimeoutTicker;
import org.apache.qpid.transport.network.io.IoNetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoNetworkTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoNetworkTransport.class);
    private static final int TIMEOUT = Integer.getInteger("qpid.io_network_transport_timeout", 60000);
    private NetworkConnection _connection;
    private static final Map<String, Socket> _registeredSockets = new ConcurrentHashMap<String, Socket>();

    protected IoNetworkConnection createNetworkConnection(Socket socket, ExceptionHandlingByteBufferReceiver engine, Integer sendBufferSize, Integer receiveBufferSize, int timeout, IdleTimeoutTicker ticker) {
        return new IoNetworkConnection(socket, engine, sendBufferSize, receiveBufferSize, timeout, ticker);
    }

    public NetworkConnection connect(ConnectionSettings settings, ExceptionHandlingByteBufferReceiver delegate, TransportActivity transportActivity) {
        Socket socket;
        if ("tcp".equalsIgnoreCase(settings.getTransport())) {
            socket = this.connectTcp(settings);
        } else if ("socket".equalsIgnoreCase(settings.getTransport())) {
            socket = _registeredSockets.remove(settings.getHost());
            if (socket == null) {
                throw new TransportException("No socket registered with id '" + settings.getHost() + "'");
            }
        } else {
            throw new TransportException("Unknown transport '" + settings.getTransport() + "'");
        }
        int sendBufferSize = settings.getWriteBufferSize();
        int receiveBufferSize = settings.getReadBufferSize();
        try {
            IdleTimeoutTicker ticker = new IdleTimeoutTicker(transportActivity, TIMEOUT);
            this._connection = this.createNetworkConnection(socket, delegate, sendBufferSize, receiveBufferSize, TIMEOUT, ticker);
            ticker.setConnection(this._connection);
            this._connection.start();
        }
        catch (Exception e) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new TransportException("Error creating network connection", e);
        }
        return this._connection;
    }

    private Socket connectTcp(ConnectionSettings settings) {
        Socket socket = new Socket();
        try {
            socket.setReuseAddress(true);
            socket.setTcpNoDelay(settings.isTcpNodelay());
            socket.setSendBufferSize(settings.getWriteBufferSize());
            socket.setReceiveBufferSize(settings.getReadBufferSize());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Socket options SO_RCVBUF : {}, SO_SNDBUF : {}, TCP_NODELAY : {}", new Object[]{socket.getReceiveBufferSize(), socket.getSendBufferSize(), socket.getTcpNoDelay()});
            }
            InetAddress address = InetAddress.getByName(settings.getHost());
            InetSocketAddress socketAddress = new InetSocketAddress(address, settings.getPort());
            socket.connect(socketAddress, settings.getConnectTimeout());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Socket connection from {} to {} established", (Object)socket.getLocalSocketAddress(), (Object)socket.getRemoteSocketAddress());
            }
        }
        catch (IOException e) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new TransportException("Error connecting to broker", e);
        }
        return socket;
    }

    public void close() {
        if (this._connection != null) {
            this._connection.close();
        }
    }

    public static void registerOpenSocket(String id, Socket socket) {
        _registeredSockets.put(id, socket);
    }

    public NetworkConnection getConnection() {
        return this._connection;
    }
}

