/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer.netty;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import java.nio.ByteBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferAllocator;
import org.apache.qpid.protonj2.buffer.ProtonCompositeBuffer;
import org.apache.qpid.protonj2.buffer.netty.Netty5ToProtonBufferAdapter;

public final class Netty5ProtonBufferAllocator
implements ProtonBufferAllocator {
    public static int DEFAULT_CAPACITY = 1024;
    public static ProtonBufferAllocator POOLED = new Netty5ProtonBufferAllocator(BufferAllocator.onHeapPooled());
    public static ProtonBufferAllocator UNPOOLED = new Netty5ProtonBufferAllocator(BufferAllocator.onHeapUnpooled());
    private boolean closed;
    private final BufferAllocator allocator;

    public Netty5ProtonBufferAllocator(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public BufferAllocator allocator() {
        return this.allocator;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public Netty5ToProtonBufferAdapter wrap(Buffer buffer) {
        this.checkClosed();
        return new Netty5ToProtonBufferAdapter(this, buffer);
    }

    @Override
    public Netty5ToProtonBufferAdapter outputBuffer(int initialCapacity) {
        return this.allocate(initialCapacity);
    }

    @Override
    public Netty5ToProtonBufferAdapter allocate() {
        return this.allocate(DEFAULT_CAPACITY);
    }

    @Override
    public Netty5ToProtonBufferAdapter allocate(int initialCapacity) {
        this.checkClosed();
        return new Netty5ToProtonBufferAdapter(this, this.allocator.allocate(initialCapacity));
    }

    @Override
    public Netty5ToProtonBufferAdapter allocateHeapBuffer() {
        return this.allocateHeapBuffer(DEFAULT_CAPACITY);
    }

    @Override
    public Netty5ToProtonBufferAdapter allocateHeapBuffer(int initialCapacity) {
        this.checkClosed();
        return new Netty5ToProtonBufferAdapter(this, BufferAllocator.onHeapUnpooled().allocate(initialCapacity));
    }

    @Override
    public Netty5ToProtonBufferAdapter copy(byte[] array) {
        this.checkClosed();
        return new Netty5ToProtonBufferAdapter(this, this.allocator.copyOf(array));
    }

    @Override
    public Netty5ToProtonBufferAdapter copy(byte[] array, int offset, int length) {
        this.checkClosed();
        return new Netty5ToProtonBufferAdapter(this, this.allocator.copyOf(ByteBuffer.wrap(array, offset, length)));
    }

    @Override
    public ProtonCompositeBuffer composite() {
        this.checkClosed();
        return ProtonCompositeBuffer.create(this);
    }

    @Override
    public ProtonCompositeBuffer composite(ProtonBuffer buffer) {
        this.checkClosed();
        return ProtonCompositeBuffer.create((ProtonBufferAllocator)this, buffer);
    }

    @Override
    public ProtonCompositeBuffer composite(ProtonBuffer[] buffers) {
        this.checkClosed();
        return ProtonCompositeBuffer.create((ProtonBufferAllocator)this, buffers);
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("This allocator instance is closed");
        }
    }
}

