/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer.netty;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferClosedException;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.BufferReadOnlyException;
import io.netty5.buffer.ByteCursor;
import io.netty5.buffer.ComponentIterator;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.util.Send;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferClosedException;
import org.apache.qpid.protonj2.buffer.ProtonBufferComponent;
import org.apache.qpid.protonj2.buffer.ProtonBufferComponentAccessor;
import org.apache.qpid.protonj2.buffer.ProtonBufferIterator;
import org.apache.qpid.protonj2.buffer.ProtonBufferReadOnlyException;

public class ProtonBufferToNetty5Adapter
implements Buffer {
    private ProtonBuffer resource;

    public ProtonBufferToNetty5Adapter(ProtonBuffer resource) {
        this.resource = resource;
    }

    public void close() {
        this.resource.close();
    }

    public Send<Buffer> send() {
        try {
            final ProtonBuffer transferred = (ProtonBuffer)this.resource.transfer();
            return new Send<Buffer>(){

                public Buffer receive() {
                    return new ProtonBufferToNetty5Adapter(transferred);
                }

                public void close() {
                    transferred.close();
                }

                public boolean referentIsInstanceOf(Class<?> cls) {
                    return cls.isAssignableFrom(ProtonBufferToNetty5Adapter.class);
                }
            };
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public boolean isAccessible() {
        return !this.resource.isClosed();
    }

    public Buffer compact() {
        try {
            this.resource.compact();
            return this;
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public Buffer makeReadOnly() {
        try {
            this.resource.convertToReadOnly();
            return this;
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public boolean readOnly() {
        return this.resource.isReadOnly();
    }

    public Buffer fill(byte value) {
        try {
            this.resource.fill(value);
            return this;
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public boolean isDirect() {
        return false;
    }

    public int capacity() {
        return this.resource.capacity();
    }

    public Buffer implicitCapacityLimit(int limit) {
        try {
            this.resource.implicitGrowthLimit(limit);
            return this;
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public int implicitCapacityLimit() {
        return this.resource.implicitGrowthLimit();
    }

    public int readerOffset() {
        return this.resource.getReadOffset();
    }

    public Buffer readerOffset(int offset) {
        try {
            this.resource.setReadOffset(offset);
            return this;
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public int writerOffset() {
        return this.resource.getWriteOffset();
    }

    public Buffer writerOffset(int offset) {
        try {
            this.resource.setWriteOffset(offset);
            return this;
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public Buffer ensureWritable(int size, int minimumGrowth, boolean allowCompaction) {
        try {
            this.resource.ensureWritable(size, minimumGrowth, allowCompaction);
            return this;
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public void copyInto(int srcPos, byte[] dest, int destPos, int length) {
        try {
            this.resource.copyInto(srcPos, dest, destPos, length);
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public void copyInto(int srcPos, ByteBuffer dest, int destPos, int length) {
        try {
            this.resource.copyInto(srcPos, dest, destPos, length);
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public void copyInto(int srcPos, Buffer destination, int destPos, int length) {
        if (!destination.isAccessible()) {
            throw new BufferClosedException("Destination buffer is closed");
        }
        if (destination.readOnly()) {
            throw new BufferReadOnlyException("Destination buffer is read only");
        }
        this.checkCopyIntoArgs(srcPos, length, destPos, destination.capacity());
        try {
            while (length >= 8) {
                destination.setLong(destPos, this.getLong(srcPos));
                length -= 8;
                srcPos += 8;
                destPos += 8;
            }
            while (length >= 4) {
                destination.setInt(destPos, this.getInt(srcPos));
                length -= 4;
                srcPos += 4;
                destPos += 4;
            }
            while (length > 0) {
                destination.setByte(destPos, this.getByte(srcPos));
                --length;
                ++srcPos;
                ++destPos;
            }
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public Buffer copy(int offset, int length, boolean readOnly) {
        try {
            return new ProtonBufferToNetty5Adapter(this.resource.copy(offset, length));
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public Buffer split(int splitOffset) {
        try {
            return new ProtonBufferToNetty5Adapter(this.resource.split(splitOffset));
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public int bytesBefore(byte needle) {
        try {
            int indexOf = this.resource.indexOf(needle);
            if (indexOf >= 0) {
                return indexOf - this.resource.getReadOffset();
            }
            return -1;
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public int bytesBefore(Buffer needle) {
        return InternalBufferUtils.bytesBefore((Buffer)this, null, (Buffer)needle, null);
    }

    public int transferTo(WritableByteChannel channel, int length) throws IOException {
        try {
            return this.resource.transferTo(channel, length);
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public int transferFrom(FileChannel channel, long position, int length) throws IOException {
        try {
            return this.resource.transferFrom(channel, position, length);
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public int transferFrom(ReadableByteChannel channel, int length) throws IOException {
        try {
            return this.resource.transferFrom(channel, length);
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public ByteCursor openCursor() {
        return this.openCursor(this.readerOffset(), this.readableBytes());
    }

    public ByteCursor openCursor(int fromOffset, int length) {
        try {
            return new ProtonBufferToNetty5ByteCursor(this.resource.bufferIterator(fromOffset, length));
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public ByteCursor openReverseCursor(int fromOffset, int length) {
        try {
            return new ProtonBufferToNetty5ByteCursor(this.resource.bufferReverseIterator(fromOffset, length));
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public int countComponents() {
        return this.resource.componentCount();
    }

    public int countReadableComponents() {
        return this.resource.readableComponentCount();
    }

    public int countWritableComponents() {
        return this.resource.writableComponentCount();
    }

    public <T extends BufferComponent & ComponentIterator.Next> ComponentIterator<T> forEachComponent() {
        try {
            return new ProtonBufferComponentIterator(this.resource.componentAccessor());
        }
        catch (RuntimeException e) {
            throw this.translateToNettyException(e);
        }
    }

    public Buffer setByte(int woff, byte value) {
        try {
            this.resource.setByte(woff, value);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer setUnsignedByte(int woff, int value) {
        try {
            this.resource.setByte(woff, (byte)(value & 0xFF));
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer setChar(int woff, char value) {
        try {
            this.resource.setChar(woff, value);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer setShort(int woff, short value) {
        try {
            this.resource.setShort(woff, value);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer setUnsignedShort(int woff, int value) {
        try {
            this.resource.setUnsignedShort(woff, (short)(value & 0xFFFF));
            return null;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer setMedium(int woff, int value) {
        try {
            this.resource.setByte(woff, (byte)(value >>> 16));
            this.resource.setByte(woff + 1, (byte)(value >>> 8));
            this.resource.setByte(woff + 2, (byte)(value >>> 0));
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer setUnsignedMedium(int woff, int value) {
        try {
            this.resource.setByte(woff, (byte)(value >>> 16));
            this.resource.setByte(woff + 1, (byte)(value >>> 8));
            this.resource.setByte(woff + 2, (byte)(value >>> 0));
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer setInt(int woff, int value) {
        try {
            this.resource.setInt(woff, value);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer setUnsignedInt(int woff, long value) {
        try {
            this.resource.setUnsignedInt(woff, (int)(value & 0xFFFFFFFFL));
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer setLong(int woff, long value) {
        try {
            this.resource.setLong(woff, value);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer setFloat(int woff, float value) {
        try {
            this.resource.setFloat(woff, value);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer setDouble(int woff, double value) {
        try {
            this.resource.setDouble(woff, value);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer writeByte(byte value) {
        try {
            this.resource.writeByte(value);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer writeUnsignedByte(int value) {
        try {
            this.resource.writeByte((byte)(value & 0xFF));
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer writeShort(short value) {
        try {
            this.resource.writeShort(value);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer writeUnsignedShort(int value) {
        try {
            this.resource.writeShort((short)(value & 0xFF));
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer writeChar(char value) {
        try {
            this.resource.writeChar(value);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer writeMedium(int value) {
        try {
            this.resource.writeByte((byte)(value >>> 16));
            this.resource.writeByte((byte)(value >>> 8));
            this.resource.writeByte((byte)(value >>> 0));
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer writeUnsignedMedium(int value) {
        try {
            this.resource.writeByte((byte)(value >>> 16));
            this.resource.writeByte((byte)(value >>> 8));
            this.resource.writeByte((byte)(value >>> 0));
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer writeInt(int value) {
        try {
            this.resource.writeInt(value);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer writeUnsignedInt(long value) {
        try {
            this.resource.writeInt((int)(value & 0xFFFFFFFFL));
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer writeLong(long value) {
        try {
            this.resource.writeLong(value);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer writeFloat(float value) {
        try {
            this.resource.writeFloat(value);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer writeDouble(double value) {
        try {
            this.resource.writeDouble(value);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public Buffer writeCharSequence(CharSequence source, Charset charset) {
        try {
            this.resource.writeCharSequence(source, charset);
            return this;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public byte getByte(int index) {
        try {
            return this.resource.getByte(index);
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public char getChar(int index) {
        try {
            return this.resource.getChar(index);
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public int getUnsignedByte(int index) {
        try {
            return this.resource.getUnsignedByte(index);
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public int getUnsignedShort(int index) {
        try {
            return this.resource.getUnsignedShort(index);
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public short getShort(int index) {
        try {
            return this.resource.getShort(index);
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public int getMedium(int index) {
        try {
            return this.getByte(index) << 16 | (this.getByte(index + 1) & 0xFF) << 8 | (this.getByte(index + 2) & 0xFF) << 0;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public int getUnsignedMedium(int index) {
        try {
            return (this.getByte(index) << 16 | (this.getByte(index + 1) & 0xFF) << 8 | (this.getByte(index + 2) & 0xFF) << 0) & 0xFFFFFF;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public int getInt(int index) {
        try {
            return this.resource.getInt(index);
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public long getUnsignedInt(int index) {
        try {
            return this.resource.getUnsignedInt(index);
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public long getLong(int index) {
        try {
            return this.resource.getLong(index);
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public float getFloat(int index) {
        try {
            return this.resource.getFloat(index);
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public double getDouble(int index) {
        try {
            return this.resource.getDouble(index);
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public byte readByte() {
        try {
            return this.resource.readByte();
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public int readUnsignedByte() {
        try {
            return this.resource.readUnsignedByte();
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public char readChar() {
        try {
            return this.resource.readChar();
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public short readShort() {
        try {
            return this.resource.readShort();
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public int readUnsignedShort() {
        try {
            return this.readShort() & 0xFFFF;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public int readMedium() {
        try {
            return this.readByte() << 16 | (this.readByte() & 0xFF) << 8 | (this.readByte() & 0xFF) << 0;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public int readUnsignedMedium() {
        try {
            return (this.readByte() << 16 | (this.readByte() & 0xFF) << 8 | (this.readByte() & 0xFF) << 0) & 0xFFFFFF;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public int readInt() {
        try {
            return this.resource.readInt();
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public long readUnsignedInt() {
        try {
            return (long)this.readInt() & 0xFFFFFFFFL;
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public long readLong() {
        try {
            return this.resource.readLong();
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public float readFloat() {
        try {
            return this.resource.readFloat();
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public double readDouble() {
        try {
            return this.resource.readDouble();
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public CharSequence readCharSequence(int length, Charset charset) {
        try {
            return this.resource.readCharSequence(length, charset);
        }
        catch (RuntimeException ex) {
            throw this.translateToNettyException(ex);
        }
    }

    public boolean equals(Object o) {
        return o instanceof Buffer && InternalBufferUtils.equals((Buffer)this, (Buffer)((Buffer)o));
    }

    public int hashCode() {
        return InternalBufferUtils.hashCode((Buffer)this);
    }

    private void checkCopyIntoArgs(int srcPos, int length, int destPos, int destLength) {
        if (this.resource.isClosed()) {
            throw new BufferClosedException("The wrapped ProtonBuffer is closed");
        }
        if (srcPos < 0) {
            throw new IndexOutOfBoundsException("The srcPos cannot be negative: " + srcPos + ".");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("The length value cannot be negative " + length + ".");
        }
        if (this.resource.capacity() < srcPos + length) {
            throw new IndexOutOfBoundsException("The srcPos + length is beyond the end of the buffer: srcPos = " + srcPos + ", length = " + length + ".");
        }
        if (destPos < 0) {
            throw new IndexOutOfBoundsException("The destPos cannot be negative: " + destPos + ".");
        }
        if (destLength < destPos + length) {
            throw new IndexOutOfBoundsException("The destPos + length is beyond the end of the destination: destPos = " + destPos + ", length = " + length + ".");
        }
    }

    private RuntimeException translateToNettyException(RuntimeException e) {
        RuntimeException result = e;
        if (e instanceof ProtonBufferReadOnlyException) {
            result = new BufferReadOnlyException("Buffer is read-only");
            result.addSuppressed(e);
        } else if (e instanceof ProtonBufferClosedException) {
            result = new BufferClosedException("Buffer is closed");
            result.addSuppressed(e);
        }
        return result;
    }

    private final class ProtonBufferToNetty5ByteCursor
    implements ByteCursor {
        private final ProtonBufferIterator iterator;
        private byte lastReadByte = (byte)-1;

        public ProtonBufferToNetty5ByteCursor(ProtonBufferIterator iterator) {
            this.iterator = iterator;
        }

        public boolean readByte() {
            if (this.iterator.hasNext()) {
                this.lastReadByte = this.iterator.next();
                return true;
            }
            return false;
        }

        public byte getByte() {
            return this.lastReadByte;
        }

        public int currentOffset() {
            return this.iterator.offset();
        }

        public int bytesLeft() {
            return this.iterator.remaining();
        }
    }

    private static class ProtonBufferComponentIterator<T extends BufferComponent & ComponentIterator.Next>
    implements ComponentIterator.Next,
    BufferComponent,
    ComponentIterator<T> {
        private ProtonBufferComponentAccessor accessor;
        private ProtonBufferComponent current;

        public ProtonBufferComponentIterator(ProtonBufferComponentAccessor accessor) {
            this.accessor = accessor;
        }

        public void close() {
            this.current = null;
            this.accessor.close();
        }

        public T first() {
            this.current = this.accessor.first();
            return (T)(this.current != null ? this : null);
        }

        public T next() {
            if (this.current != null) {
                this.current = this.accessor.next();
            }
            return (T)(this.current != null ? this : null);
        }

        public boolean hasReadableArray() {
            return this.current.hasReadbleArray();
        }

        public boolean hasWritableArray() {
            return this.current.hasWritableArray();
        }

        public byte[] readableArray() {
            return this.current.getReadableArray();
        }

        public byte[] writableArray() {
            return this.current.getWritableArray();
        }

        public int readableArrayOffset() {
            return this.current.getReadableArrayOffset();
        }

        public int writableArrayOffset() {
            return this.current.getWritableArrayOffset();
        }

        public int readableArrayLength() {
            return this.current.getReadableArrayLength();
        }

        public int writableArrayLength() {
            return this.current.getWritableArrayLength();
        }

        public long baseNativeAddress() {
            return this.current.getNativeAddress();
        }

        public long readableNativeAddress() {
            return this.current.getNativeReadAddress();
        }

        public long writableNativeAddress() {
            return this.current.getNativeWriteAddress();
        }

        public ByteBuffer readableBuffer() {
            return this.current.getReadableBuffer();
        }

        public ByteBuffer writableBuffer() {
            return this.current.getWritableBuffer();
        }

        public int readableBytes() {
            return this.current.getReadableBytes();
        }

        public int writableBytes() {
            return this.current.getWritableBytes();
        }

        public ByteCursor openCursor() {
            return new ProtonByteCursorAdapter(this.current.bufferIterator());
        }

        public BufferComponent skipReadableBytes(int byteCount) {
            this.current.advanceReadOffset(byteCount);
            return this;
        }

        public BufferComponent skipWritableBytes(int byteCount) {
            this.current.advanceWriteOffset(byteCount);
            return this;
        }
    }

    private static final class ProtonByteCursorAdapter
    implements ByteCursor {
        private final ProtonBufferIterator iterator;
        private byte lastByte = (byte)-1;

        public ProtonByteCursorAdapter(ProtonBufferIterator iterator) {
            this.iterator = iterator;
        }

        public boolean readByte() {
            if (this.iterator.hasNext()) {
                this.lastByte = this.iterator.next();
                return true;
            }
            return false;
        }

        public byte getByte() {
            return this.lastByte;
        }

        public int currentOffset() {
            return this.iterator.offset();
        }

        public int bytesLeft() {
            return this.iterator.remaining();
        }
    }
}

