/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types.messaging;

import java.util.UUID;
import org.apache.qpid.protonj2.types.Binary;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedInteger;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Section;

public final class Properties
implements Section<Properties> {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(115L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:properties:list");
    private static final int MESSAGE_ID = 1;
    private static final int USER_ID = 2;
    private static final int TO = 4;
    private static final int SUBJECT = 8;
    private static final int REPLY_TO = 16;
    private static final int CORRELATION_ID = 32;
    private static final int CONTENT_TYPE = 64;
    private static final int CONTENT_ENCODING = 128;
    private static final int ABSOLUTE_EXPIRY = 256;
    private static final int CREATION_TIME = 512;
    private static final int GROUP_ID = 1024;
    private static final int GROUP_SEQUENCE = 2048;
    private static final int REPLY_TO_GROUP_ID = 4096;
    private int modified = 0;
    private Object messageId;
    private Binary userId;
    private String to;
    private String subject;
    private String replyTo;
    private Object correlationId;
    private String contentType;
    private String contentEncoding;
    private long absoluteExpiryTime;
    private long creationTime;
    private String groupId;
    private long groupSequence;
    private String replyToGroupId;

    public Properties() {
    }

    public Properties(Properties other) {
        this.messageId = other.messageId;
        this.userId = other.userId;
        this.to = other.to;
        this.subject = other.subject;
        this.replyTo = other.replyTo;
        this.correlationId = other.correlationId;
        this.contentType = other.contentType;
        this.contentEncoding = other.contentEncoding;
        this.absoluteExpiryTime = other.absoluteExpiryTime;
        this.creationTime = other.creationTime;
        this.groupId = other.groupId;
        this.groupSequence = other.groupSequence;
        this.replyToGroupId = other.replyToGroupId;
        this.modified = other.modified;
    }

    public Properties copy() {
        return new Properties(this);
    }

    @Override
    public Properties getValue() {
        return this;
    }

    public boolean isEmpty() {
        return this.modified == 0;
    }

    public int getElementCount() {
        return 32 - Integer.numberOfLeadingZeros(this.modified);
    }

    public boolean hasMessageId() {
        return (this.modified & 1) == 1;
    }

    public boolean hasUserId() {
        return (this.modified & 2) == 2;
    }

    public boolean hasTo() {
        return (this.modified & 4) == 4;
    }

    public boolean hasSubject() {
        return (this.modified & 8) == 8;
    }

    public boolean hasReplyTo() {
        return (this.modified & 0x10) == 16;
    }

    public boolean hasCorrelationId() {
        return (this.modified & 0x20) == 32;
    }

    public boolean hasContentType() {
        return (this.modified & 0x40) == 64;
    }

    public boolean hasContentEncoding() {
        return (this.modified & 0x80) == 128;
    }

    public boolean hasAbsoluteExpiryTime() {
        return (this.modified & 0x100) == 256;
    }

    public boolean hasCreationTime() {
        return (this.modified & 0x200) == 512;
    }

    public boolean hasGroupId() {
        return (this.modified & 0x400) == 1024;
    }

    public boolean hasGroupSequence() {
        return (this.modified & 0x800) == 2048;
    }

    public boolean hasReplyToGroupId() {
        return (this.modified & 0x1000) == 4096;
    }

    public Object getMessageId() {
        return this.messageId;
    }

    public Properties setMessageId(Object messageId) {
        Properties.validateIsMessageIdType(messageId);
        this.modified = messageId == null ? (this.modified &= 0xFFFFFFFE) : (this.modified |= 1);
        this.messageId = messageId;
        return this;
    }

    private static void validateIsMessageIdType(Object messageId) {
        if (messageId == null || messageId instanceof String || messageId instanceof UUID || messageId instanceof UnsignedLong || messageId instanceof Binary) {
            return;
        }
        throw new IllegalArgumentException("AMQP Message ID type restriction violated, cannot assign type: " + messageId.getClass().getName());
    }

    public Binary getUserId() {
        return this.userId;
    }

    public Properties setUserId(byte[] userId) {
        if (userId == null) {
            this.setUserId((Binary)null);
        } else {
            this.setUserId(new Binary(userId));
        }
        return this;
    }

    public Properties setUserId(Binary userId) {
        this.modified = userId == null ? (this.modified &= 0xFFFFFFFD) : (this.modified |= 2);
        this.userId = userId;
        return this;
    }

    public String getTo() {
        return this.to;
    }

    public Properties setTo(String to) {
        this.modified = to == null ? (this.modified &= 0xFFFFFFFB) : (this.modified |= 4);
        this.to = to;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public Properties setSubject(String subject) {
        this.modified = subject == null ? (this.modified &= 0xFFFFFFF7) : (this.modified |= 8);
        this.subject = subject;
        return this;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public Properties setReplyTo(String replyTo) {
        this.modified = replyTo == null ? (this.modified &= 0xFFFFFFEF) : (this.modified |= 0x10);
        this.replyTo = replyTo;
        return this;
    }

    public Object getCorrelationId() {
        return this.correlationId;
    }

    public Properties setCorrelationId(Object correlationId) {
        Properties.validateIsMessageIdType(correlationId);
        this.modified = correlationId == null ? (this.modified &= 0xFFFFFFDF) : (this.modified |= 0x20);
        this.correlationId = correlationId;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Properties setContentType(String contentType) {
        this.modified = contentType == null ? (this.modified &= 0xFFFFFFBF) : (this.modified |= 0x40);
        this.contentType = contentType;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public Properties setContentEncoding(String contentEncoding) {
        this.modified = contentEncoding == null ? (this.modified &= 0xFFFFFF7F) : (this.modified |= 0x80);
        this.contentEncoding = contentEncoding;
        return this;
    }

    public long getAbsoluteExpiryTime() {
        return this.absoluteExpiryTime;
    }

    public Properties setAbsoluteExpiryTime(int absoluteExpiryTime) {
        this.modified |= 0x100;
        this.absoluteExpiryTime = Integer.toUnsignedLong(absoluteExpiryTime);
        return this;
    }

    public Properties setAbsoluteExpiryTime(long absoluteExpiryTime) {
        this.modified |= 0x100;
        this.absoluteExpiryTime = absoluteExpiryTime;
        return this;
    }

    public void clearAbsoluteExpiryTime() {
        this.modified &= 0xFFFFFEFF;
        this.absoluteExpiryTime = 0L;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Properties setCreationTime(int creationTime) {
        this.modified |= 0x200;
        this.creationTime = Integer.toUnsignedLong(creationTime);
        return this;
    }

    public Properties setCreationTime(long creationTime) {
        this.modified |= 0x200;
        this.creationTime = creationTime;
        return this;
    }

    public void clearCreationTime() {
        this.modified &= 0xFFFFFDFF;
        this.creationTime = 0L;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Properties setGroupId(String groupId) {
        this.modified = groupId == null ? (this.modified &= 0xFFFFFBFF) : (this.modified |= 0x400);
        this.groupId = groupId;
        return this;
    }

    public long getGroupSequence() {
        return this.groupSequence;
    }

    public Properties setGroupSequence(int groupSequence) {
        this.modified |= 0x800;
        this.groupSequence = Integer.toUnsignedLong(groupSequence);
        return this;
    }

    public Properties setGroupSequence(long groupSequence) {
        if (groupSequence < 0L || groupSequence > UnsignedInteger.MAX_VALUE.longValue()) {
            throw new IllegalArgumentException("Group Sequence value given is out of range: " + groupSequence);
        }
        this.modified |= 0x800;
        this.groupSequence = groupSequence;
        return this;
    }

    public void clearGroupSequence() {
        this.modified &= 0xFFFFF7FF;
        this.groupSequence = 0L;
    }

    public String getReplyToGroupId() {
        return this.replyToGroupId;
    }

    public Properties setReplyToGroupId(String replyToGroupId) {
        this.modified = replyToGroupId == null ? (this.modified &= 0xFFFFEFFF) : (this.modified |= 0x1000);
        this.replyToGroupId = replyToGroupId;
        return this;
    }

    public String toString() {
        return "Properties{messageId=" + String.valueOf(this.messageId) + ", userId=" + String.valueOf(this.userId) + ", to='" + this.to + "', subject='" + this.subject + "', replyTo='" + this.replyTo + "', correlationId=" + String.valueOf(this.correlationId) + ", contentType=" + this.contentType + ", contentEncoding=" + this.contentEncoding + ", absoluteExpiryTime=" + String.valueOf(this.hasAbsoluteExpiryTime() ? Long.valueOf(this.absoluteExpiryTime) : "null") + ", creationTime=" + (this.hasCreationTime() ? Long.valueOf(this.creationTime) : null) + ", groupId='" + this.groupId + "', groupSequence=" + (this.hasGroupSequence() ? Long.valueOf(this.groupSequence) : null) + ", replyToGroupId='" + this.replyToGroupId + "' }";
    }

    @Override
    public Section.SectionType getType() {
        return Section.SectionType.Properties;
    }
}

