/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.queue;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuditIndexRecord;
import org.apache.ranger.audit.model.SPOOL_FILE_STATUS;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.queue.AuditQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AuditFileSpool
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AuditFileSpool.class);
    public static final String PROP_FILE_SPOOL_LOCAL_DIR = "filespool.dir";
    public static final String PROP_FILE_SPOOL_LOCAL_FILE_NAME = "filespool.filename.format";
    public static final String PROP_FILE_SPOOL_ARCHIVE_DIR = "filespool.archive.dir";
    public static final String PROP_FILE_SPOOL_ARCHIVE_MAX_FILES_COUNT = "filespool.archive.max.files";
    public static final String PROP_FILE_SPOOL_FILENAME_PREFIX = "filespool.file.prefix";
    public static final String PROP_FILE_SPOOL_FILE_ROLLOVER = "filespool.file.rollover.sec";
    public static final String PROP_FILE_SPOOL_INDEX_FILE = "filespool.index.filename";
    public static final String PROP_FILE_SPOOL_DEST_RETRY_MS = "filespool.destination.retry.ms";
    public static final String CONSUMER = ", consumer=";
    AuditQueue queueProvider = null;
    AuditHandler consumerProvider = null;
    BlockingQueue<AuditIndexRecord> indexQueue = new LinkedBlockingQueue<AuditIndexRecord>();
    File logFolder = null;
    String logFileNameFormat = null;
    File archiveFolder = null;
    String fileNamePrefix = null;
    String indexFileName = null;
    File indexFile = null;
    String indexDoneFileName = null;
    File indexDoneFile = null;
    int retryDestinationMS = 30000;
    int fileRolloverSec = 86400;
    int maxArchiveFiles = 100;
    int errorLogIntervalMS = 30000;
    long lastErrorLogMS = 0L;
    List<AuditIndexRecord> indexRecords = new ArrayList<AuditIndexRecord>();
    boolean isPending = false;
    long lastAttemptTime = 0L;
    boolean initDone = false;
    PrintWriter logWriter = null;
    AuditIndexRecord currentWriterIndexRecord = null;
    AuditIndexRecord currentConsumerIndexRecord = null;
    BufferedReader logReader = null;
    Thread destinationThread = null;
    boolean isWriting = true;
    boolean isDrain = false;
    boolean isDestDown = false;

    public AuditFileSpool(AuditQueue queueProvider, AuditHandler consumerProvider) {
        this.queueProvider = queueProvider;
        this.consumerProvider = consumerProvider;
    }

    public void init(Properties prop) {
        this.init(prop, null);
    }

    public boolean init(Properties props, String basePropertyName) {
        if (this.initDone) {
            logger.error("init() called more than once. queueProvider={}, consumerProvider={}", (Object)this.queueProvider.getName(), (Object)this.consumerProvider.getName());
            return true;
        }
        String propPrefix = "xasecure.audit.filespool";
        if (basePropertyName != null) {
            propPrefix = basePropertyName;
        }
        try {
            boolean ret;
            boolean ret2;
            String logFolderProp = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_LOCAL_DIR);
            this.logFileNameFormat = MiscUtil.getStringProperty(props, basePropertyName + "." + PROP_FILE_SPOOL_LOCAL_FILE_NAME);
            String archiveFolderProp = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_ARCHIVE_DIR);
            this.fileNamePrefix = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_FILENAME_PREFIX);
            this.indexFileName = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_INDEX_FILE);
            this.retryDestinationMS = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_DEST_RETRY_MS, this.retryDestinationMS);
            this.fileRolloverSec = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_FILE_ROLLOVER, this.fileRolloverSec);
            this.maxArchiveFiles = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_ARCHIVE_MAX_FILES_COUNT, this.maxArchiveFiles);
            logger.info("retryDestinationMS={}, queueName={}", (Object)this.retryDestinationMS, (Object)this.queueProvider.getName());
            logger.info("fileRolloverSec={}, queueName={}", (Object)this.fileRolloverSec, (Object)this.queueProvider.getName());
            logger.info("maxArchiveFiles={}, queueName={}", (Object)this.maxArchiveFiles, (Object)this.queueProvider.getName());
            if (logFolderProp == null || logFolderProp.isEmpty()) {
                logger.error("Audit spool folder is not configured. Please set {}.{}. queueName={}", new Object[]{propPrefix, PROP_FILE_SPOOL_LOCAL_DIR, this.queueProvider.getName()});
                return false;
            }
            this.logFolder = new File(logFolderProp);
            if (!this.logFolder.isDirectory()) {
                this.logFolder.mkdirs();
                if (!this.logFolder.isDirectory()) {
                    logger.error("File Spool folder not found and can't be created. folder={}, queueName={}", (Object)this.logFolder.getAbsolutePath(), (Object)this.queueProvider.getName());
                    return false;
                }
            }
            logger.info("logFolder={}, queueName={}", (Object)this.logFolder, (Object)this.queueProvider.getName());
            if (this.logFileNameFormat == null || this.logFileNameFormat.isEmpty()) {
                this.logFileNameFormat = "spool_%app-type%_%time:yyyyMMdd-HHmm.ss%.log";
            }
            logger.info("logFileNameFormat={}, queueName={}", (Object)this.logFileNameFormat, (Object)this.queueProvider.getName());
            this.archiveFolder = archiveFolderProp == null || archiveFolderProp.isEmpty() ? new File(this.logFolder, "archive") : new File(archiveFolderProp);
            if (!this.archiveFolder.isDirectory()) {
                this.archiveFolder.mkdirs();
                if (!this.archiveFolder.isDirectory()) {
                    logger.error("File Spool archive folder not found and can't be created. folder={}, queueName={}", (Object)this.archiveFolder.getAbsolutePath(), (Object)this.queueProvider.getName());
                    return false;
                }
            }
            logger.info("archiveFolder={}, queueName={}", (Object)this.archiveFolder, (Object)this.queueProvider.getName());
            if (this.indexFileName == null || this.indexFileName.isEmpty()) {
                if (this.fileNamePrefix == null || this.fileNamePrefix.isEmpty()) {
                    this.fileNamePrefix = this.queueProvider.getName() + "_" + this.consumerProvider.getName();
                }
                this.indexFileName = "index_" + this.fileNamePrefix + "_%app-type%.json";
                this.indexFileName = MiscUtil.replaceTokens(this.indexFileName, System.currentTimeMillis());
            }
            this.indexFile = new File(this.logFolder, this.indexFileName);
            if (!this.indexFile.exists() && !(ret2 = this.indexFile.createNewFile())) {
                logger.error("Error creating index file. fileName={}", (Object)this.indexDoneFile.getPath());
                return false;
            }
            logger.info("indexFile={}, queueName={}", (Object)this.indexFile, (Object)this.queueProvider.getName());
            int lastDot = this.indexFileName.lastIndexOf(46);
            if (lastDot < 0) {
                lastDot = this.indexFileName.length() - 1;
            }
            this.indexDoneFileName = this.indexFileName.substring(0, lastDot) + "_closed.json";
            this.indexDoneFile = new File(this.logFolder, this.indexDoneFileName);
            if (!this.indexDoneFile.exists() && !(ret = this.indexDoneFile.createNewFile())) {
                logger.error("Error creating index done file. fileName={}", (Object)this.indexDoneFile.getPath());
                return false;
            }
            logger.info("indexDoneFile={}, queueName={}", (Object)this.indexDoneFile, (Object)this.queueProvider.getName());
            this.loadIndexFile();
            for (AuditIndexRecord auditIndexRecord : this.indexRecords) {
                if (!auditIndexRecord.getStatus().equals((Object)SPOOL_FILE_STATUS.done)) {
                    this.isPending = true;
                }
                if (auditIndexRecord.getStatus().equals((Object)SPOOL_FILE_STATUS.write_inprogress)) {
                    this.currentWriterIndexRecord = auditIndexRecord;
                    logger.info("currentWriterIndexRecord={}, queueName={}", (Object)this.currentWriterIndexRecord.getFilePath(), (Object)this.queueProvider.getName());
                }
                if (!auditIndexRecord.getStatus().equals((Object)SPOOL_FILE_STATUS.read_inprogress)) continue;
                this.indexQueue.add(auditIndexRecord);
            }
            this.printIndex();
            for (AuditIndexRecord auditIndexRecord : this.indexRecords) {
                if (!auditIndexRecord.getStatus().equals((Object)SPOOL_FILE_STATUS.pending)) continue;
                File consumerFile = new File(auditIndexRecord.getFilePath());
                if (!consumerFile.exists()) {
                    logger.error("INIT: Consumer file={} not found.", (Object)consumerFile.getPath());
                    continue;
                }
                this.indexQueue.add(auditIndexRecord);
            }
        }
        catch (Throwable t) {
            logger.error("Error initializing File Spooler. queue=" + this.queueProvider.getName(), t);
            return false;
        }
        this.initDone = true;
        return true;
    }

    public void start() {
        if (!this.initDone) {
            logger.error("Cannot start Audit File Spooler. Initilization not done yet. queueName={}", (Object)this.queueProvider.getName());
            return;
        }
        logger.info("Starting writerThread, queueName={}, consumer={}", (Object)this.queueProvider.getName(), (Object)this.consumerProvider.getName());
        this.destinationThread = new Thread((Runnable)this, this.queueProvider.getName() + "_" + this.consumerProvider.getName() + "_destWriter");
        this.destinationThread.setDaemon(true);
        this.destinationThread.start();
    }

    public void stop() {
        if (!this.initDone) {
            logger.error("Cannot stop Audit File Spooler. Initilization not done. queueName={}", (Object)this.queueProvider.getName());
            return;
        }
        logger.info("Stop called, queueName={}, consumer={}", (Object)this.queueProvider.getName(), (Object)this.consumerProvider.getName());
        this.isDrain = true;
        this.flush();
        PrintWriter out = this.getOpenLogFileStream();
        if (out != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.isWriting) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    logger.info("Closing open file, queueName={}, consumer={}", (Object)this.queueProvider.getName(), (Object)this.consumerProvider.getName());
                    out.flush();
                    out.close();
                    break;
                }
                catch (Throwable t) {
                    logger.debug("Error closing spool out file.", t);
                }
            }
        }
        try {
            if (this.destinationThread != null) {
                this.destinationThread.interrupt();
            }
            this.destinationThread = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void flush() {
        if (!this.initDone) {
            logger.error("Cannot flush Audit File Spooler. Initilization not done. queueName={}", (Object)this.queueProvider.getName());
            return;
        }
        PrintWriter out = this.getOpenLogFileStream();
        if (out != null) {
            out.flush();
        }
    }

    public boolean isPending() {
        if (!this.initDone) {
            this.logError("isPending(): File Spooler not initialized. queueName={}", this.queueProvider.getName());
            return false;
        }
        return this.isPending;
    }

    public long getLastAttemptTimeDelta() {
        if (this.lastAttemptTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.lastAttemptTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stashLogs(AuditEventBase event) {
        if (this.isDrain) {
            logger.error("stashLogs() is called after stop is called. event={}", (Object)event);
            return;
        }
        try {
            this.isWriting = true;
            PrintWriter logOut = this.getLogFileStream();
            String jsonStr = MiscUtil.stringify(event);
            logOut.println(jsonStr);
            this.isPending = true;
        }
        catch (Exception ex) {
            logger.error("Error writing to file. event={}", (Object)event, (Object)ex);
        }
        finally {
            this.isWriting = false;
        }
    }

    public synchronized void stashLogs(Collection<AuditEventBase> events) {
        for (AuditEventBase event : events) {
            this.stashLogs(event);
        }
        this.flush();
    }

    public synchronized void stashLogsString(String event) {
        if (this.isDrain) {
            logger.error("stashLogs() is called after stop is called. event={}", (Object)event);
            return;
        }
        try {
            this.isWriting = true;
            PrintWriter logOut = this.getLogFileStream();
            logOut.println(event);
        }
        catch (Exception ex) {
            logger.error("Error writing to file. event={}", (Object)event, (Object)ex);
        }
        finally {
            this.isWriting = false;
        }
    }

    public synchronized void stashLogsString(Collection<String> events) {
        for (String event : events) {
            this.stashLogsString(event);
        }
        this.flush();
    }

    private synchronized PrintWriter getOpenLogFileStream() {
        return this.logWriter;
    }

    private synchronized PrintWriter getLogFileStream() throws Exception {
        this.closeFileIfNeeded();
        if (this.currentWriterIndexRecord == null) {
            String fileName;
            Date currentTime = new Date();
            String newFileName = fileName = MiscUtil.replaceTokens(this.logFileNameFormat, currentTime.getTime());
            File outLogFile = null;
            int i = 0;
            while (true) {
                outLogFile = new File(this.logFolder, newFileName);
                File archiveLogFile = new File(this.archiveFolder, newFileName);
                if (!outLogFile.exists() && !archiveLogFile.exists()) break;
                int lastDot = fileName.lastIndexOf(46);
                String baseName = fileName.substring(0, lastDot);
                String extension = fileName.substring(lastDot);
                newFileName = baseName + "." + ++i + extension;
            }
            fileName = newFileName;
            logger.info("Creating new file. queueName={}, filename={}", (Object)this.queueProvider.getName(), (Object)fileName);
            this.logWriter = new PrintWriter(new BufferedWriter(new FileWriter(outLogFile)));
            AuditIndexRecord tmpIndexRecord = new AuditIndexRecord();
            tmpIndexRecord.setId(MiscUtil.generateUniqueId());
            tmpIndexRecord.setFilePath(outLogFile.getPath());
            tmpIndexRecord.setStatus(SPOOL_FILE_STATUS.write_inprogress);
            tmpIndexRecord.setFileCreateTime(currentTime);
            tmpIndexRecord.setLastAttempt(true);
            this.currentWriterIndexRecord = tmpIndexRecord;
            this.indexRecords.add(this.currentWriterIndexRecord);
            this.saveIndexFile();
        } else if (this.logWriter == null) {
            logger.info("Opening existing file for append. queueName={}, filename={}", (Object)this.queueProvider.getName(), (Object)this.currentWriterIndexRecord.getFilePath());
            this.logWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.currentWriterIndexRecord.getFilePath(), true)));
        }
        return this.logWriter;
    }

    private synchronized void closeFileIfNeeded() throws IOException {
        if (this.currentWriterIndexRecord != null) {
            boolean closeFile = false;
            if (this.indexRecords.size() == 1) {
                closeFile = true;
                logger.info("Closing file. Only one open file. queueName=" + this.queueProvider.getName() + ", fileName=" + this.currentWriterIndexRecord.getFilePath());
            } else if (System.currentTimeMillis() - this.currentWriterIndexRecord.getFileCreateTime().getTime() > (long)(this.fileRolloverSec * 1000)) {
                closeFile = true;
                logger.info("Closing file. Only one open file. queueName={}, filename={}", (Object)this.queueProvider.getName(), (Object)this.currentWriterIndexRecord.getFilePath());
            }
            if (closeFile) {
                if (this.logWriter != null) {
                    this.logWriter.flush();
                    this.logWriter.close();
                    this.logWriter = null;
                }
                this.currentWriterIndexRecord.setStatus(SPOOL_FILE_STATUS.pending);
                this.currentWriterIndexRecord.setWriteCompleteTime(new Date());
                this.saveIndexFile();
                logger.info("Adding file to queue. queueName={}, filename={}", (Object)this.queueProvider.getName(), (Object)this.currentWriterIndexRecord.getFilePath());
                this.indexQueue.add(this.currentWriterIndexRecord);
                this.currentWriterIndexRecord = null;
            }
        }
    }

    void loadIndexFile() throws IOException {
        logger.info("Loading index file. fileName={}", (Object)this.indexFile.getPath());
        try (BufferedReader br = new BufferedReader(new FileReader(this.indexFile));){
            String line;
            this.indexRecords.clear();
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                AuditIndexRecord record = MiscUtil.fromJson(line, AuditIndexRecord.class);
                this.indexRecords.add(record);
            }
        }
    }

    synchronized void printIndex() {
        logger.info("INDEX printIndex() ==== START");
        for (AuditIndexRecord record : this.indexRecords) {
            logger.info("INDEX={}, isFileExist={}", (Object)record, (Object)new File(record.getFilePath()).exists());
        }
        logger.info("INDEX printIndex() ==== END");
    }

    synchronized void removeIndexRecord(AuditIndexRecord indexRecord) throws FileNotFoundException, IOException {
        Iterator<AuditIndexRecord> iter = this.indexRecords.iterator();
        while (iter.hasNext()) {
            AuditIndexRecord record = iter.next();
            if (!record.getId().equals(indexRecord.getId())) continue;
            logger.info("Removing file from index. file={}, queueName={}, consumer={}", new Object[]{record.getFilePath(), this.queueProvider.getName(), this.consumerProvider.getName()});
            iter.remove();
            this.appendToDoneFile(record);
        }
        this.saveIndexFile();
        if (this.indexRecords.isEmpty()) {
            this.isPending = false;
        }
    }

    synchronized void saveIndexFile() throws IOException {
        try (PrintWriter out = new PrintWriter(this.indexFile);){
            for (AuditIndexRecord auditIndexRecord : this.indexRecords) {
                out.println(MiscUtil.stringify(auditIndexRecord));
            }
        }
    }

    void appendToDoneFile(AuditIndexRecord indexRecord) throws IOException {
        block21: {
            logger.info("Moving to done file. {}, queueName={}, consumer={}", new Object[]{indexRecord.getFilePath(), this.queueProvider.getName(), this.consumerProvider.getName()});
            String line = MiscUtil.stringify(indexRecord);
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.indexDoneFile, true)));
            out.println(line);
            out.flush();
            out.close();
            File logFile = null;
            File archiveFile = null;
            try {
                logFile = new File(indexRecord.getFilePath());
                String fileName = logFile.getName();
                archiveFile = new File(this.archiveFolder, fileName);
                logger.info("Moving logFile{} to {}", (Object)logFile, (Object)archiveFile);
                boolean filedRenamed = logFile.renameTo(archiveFile);
                if (logger.isDebugEnabled()) {
                    logger.debug("logFile renamed to archiveFile {}{}", (Object)archiveFile, (Object)filedRenamed);
                }
            }
            catch (Exception t) {
                logger.error("Error moving log file to archive folder. logFile={}, archiveFile={}", new Object[]{logFile, archiveFile, t});
            }
            archiveFile = null;
            try {
                File[] logFiles = this.archiveFolder.listFiles(pathname -> pathname.getName().toLowerCase().endsWith(".log"));
                if (logFiles == null || logFiles.length <= this.maxArchiveFiles) break block21;
                int filesToDelete = logFiles.length - this.maxArchiveFiles;
                try (BufferedReader br = new BufferedReader(new FileReader(this.indexDoneFile));){
                    int filesDeletedCount = 0;
                    while ((line = br.readLine()) != null) {
                        if (line.isEmpty() || line.startsWith("#")) continue;
                        try {
                            AuditIndexRecord record = MiscUtil.fromJson(line, AuditIndexRecord.class);
                            logFile = new File(record.getFilePath());
                            String fileName = logFile.getName();
                            archiveFile = new File(this.archiveFolder, fileName);
                            if (!archiveFile.exists()) continue;
                            logger.info("Deleting archive file {}", (Object)archiveFile);
                            boolean ret = archiveFile.delete();
                            if (!ret) {
                                logger.error("Error deleting archive file. archiveFile={}", (Object)archiveFile);
                            }
                            if (++filesDeletedCount < filesToDelete) continue;
                            logger.info("Deleted {} files", (Object)filesDeletedCount);
                            break;
                        }
                        catch (Exception e) {
                            logger.error("Error parsing following JSON: " + line, (Throwable)e);
                        }
                    }
                }
            }
            catch (Exception t) {
                logger.error("Error deleting older archive file. archiveFile=" + archiveFile, (Throwable)t);
            }
        }
    }

    void logError(String msg, Object ... arguments) {
        long currTimeMS = System.currentTimeMillis();
        if (currTimeMS - this.lastErrorLogMS > (long)this.errorLogIntervalMS) {
            logger.error(msg, arguments);
            this.lastErrorLogMS = currTimeMS;
        }
    }

    @Override
    public void run() {
        try {
            MDC.clear();
            this.runLogAudit();
        }
        catch (Exception t) {
            logger.error("Exited thread without abnormaly. queue=" + this.consumerProvider.getName(), (Throwable)t);
        }
    }

    public void runLogAudit() {
        block14: while (true) {
            try {
                while (true) {
                    if (this.isDestDown) {
                        logger.info("Destination is down. sleeping for {} milli seconds. indexQueue={}, queueName={}, consumer={}", new Object[]{this.retryDestinationMS, this.indexQueue.size(), this.queueProvider.getName(), this.consumerProvider.getName()});
                        Thread.sleep(this.retryDestinationMS);
                    }
                    if (this.currentConsumerIndexRecord == null) {
                        this.currentConsumerIndexRecord = this.indexQueue.poll(this.retryDestinationMS, TimeUnit.MILLISECONDS);
                    } else {
                        Thread.sleep(this.retryDestinationMS);
                    }
                    if (this.isDrain) break block14;
                    if (this.currentConsumerIndexRecord == null) {
                        this.closeFileIfNeeded();
                        continue;
                    }
                    boolean isRemoveIndex = false;
                    File consumerFile = new File(this.currentConsumerIndexRecord.getFilePath());
                    if (!consumerFile.exists()) {
                        logger.error("Consumer file={} not found.", (Object)consumerFile.getPath());
                        this.printIndex();
                        isRemoveIndex = true;
                    } else {
                        try (BufferedReader br = new BufferedReader(new FileReader(this.currentConsumerIndexRecord.getFilePath()));){
                            boolean ret;
                            String line;
                            int startLine = this.currentConsumerIndexRecord.getLinePosition();
                            int currLine = 0;
                            ArrayList<String> lines = new ArrayList<String>();
                            while ((line = br.readLine()) != null) {
                                if (++currLine < startLine) continue;
                                lines.add(line);
                                if (lines.size() != this.queueProvider.getMaxBatchSize()) continue;
                                ret = this.sendEvent(lines, this.currentConsumerIndexRecord, currLine);
                                if (!ret) {
                                    throw new Exception("Destination down");
                                }
                                lines.clear();
                            }
                            if (!lines.isEmpty()) {
                                ret = this.sendEvent(lines, this.currentConsumerIndexRecord, currLine);
                                if (!ret) {
                                    throw new Exception("Destination down");
                                }
                                lines.clear();
                            }
                            logger.info("Done reading file. file={}, queueName={}, consumer={}", new Object[]{this.currentConsumerIndexRecord.getFilePath(), this.queueProvider.getName(), this.consumerProvider.getName()});
                            this.currentConsumerIndexRecord.setStatus(SPOOL_FILE_STATUS.done);
                            this.currentConsumerIndexRecord.setDoneCompleteTime(new Date());
                            this.currentConsumerIndexRecord.setLastAttempt(true);
                            isRemoveIndex = true;
                        }
                        catch (Exception ex) {
                            this.isDestDown = true;
                            this.logError("Destination down. queueName={}, consumer={}", this.queueProvider.getName(), this.consumerProvider.getName());
                            this.lastAttemptTime = System.currentTimeMillis();
                            this.currentConsumerIndexRecord.setLastFailedTime(new Date());
                            this.currentConsumerIndexRecord.setFailedAttemptCount(this.currentConsumerIndexRecord.getFailedAttemptCount() + 1);
                            this.currentConsumerIndexRecord.setLastAttempt(false);
                            this.saveIndexFile();
                        }
                    }
                    if (!isRemoveIndex) continue;
                    this.removeIndexRecord(this.currentConsumerIndexRecord);
                    this.currentConsumerIndexRecord = null;
                    this.closeFileIfNeeded();
                }
            }
            catch (InterruptedException e) {
                logger.info("Caught exception in consumer thread. Shutdown might be in progress");
            }
            catch (Exception t) {
                logger.error("Exception in destination writing thread.", (Throwable)t);
                continue;
            }
            break;
        }
        logger.info("Exiting file spooler. provider={}, consumer={}", (Object)this.queueProvider.getName(), (Object)this.consumerProvider.getName());
    }

    private boolean sendEvent(List<String> lines, AuditIndexRecord indexRecord, int currLine) {
        boolean ret = true;
        try {
            ret = this.consumerProvider.logJSON(lines);
            if (!ret) {
                this.logError("Error sending logs to consumer. provider={}, consumer={}", this.queueProvider.getName(), this.consumerProvider.getName());
            } else {
                indexRecord.setLinePosition(currLine);
                indexRecord.setStatus(SPOOL_FILE_STATUS.read_inprogress);
                indexRecord.setLastSuccessTime(new Date());
                indexRecord.setLastAttempt(true);
                this.saveIndexFile();
                if (this.isDestDown) {
                    this.isDestDown = false;
                    logger.info("Destination up now. {}, queueName={}, consumer={}", new Object[]{indexRecord.getFilePath(), this.queueProvider.getName(), this.consumerProvider.getName()});
                }
            }
        }
        catch (Exception t) {
            logger.error("Error while sending logs to consumer. provider={}, consumer={}, logEventCount={}", new Object[]{this.queueProvider.getName(), this.consumerProvider.getName(), lines.size(), t});
        }
        return ret;
    }

    class AuditFileSpoolAttempt {
        Date attemptTime;
        String status;

        AuditFileSpoolAttempt() {
        }
    }
}

