/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.util.ArrayList;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.util.packed.PackedLongValues;
import org.elasticsearch.search.aggregations.bucket.BestBucketsDeferringCollector;
import org.elasticsearch.search.internal.SearchContext;

public class MergingBucketsDeferringCollector
extends BestBucketsDeferringCollector {
    public MergingBucketsDeferringCollector(SearchContext context, boolean isGlobal) {
        super(context, isGlobal);
    }

    @Deprecated
    public void mergeBuckets(long[] mergeMap) {
        this.mergeBuckets(bucket -> mergeMap[Math.toIntExact(bucket)]);
    }

    public void mergeBuckets(LongUnaryOperator mergeMap) {
        long ordinal;
        long delta;
        long lastGoodDelta;
        PackedLongValues.Iterator docDeltasItr;
        ArrayList<BestBucketsDeferringCollector.Entry> newEntries = new ArrayList<BestBucketsDeferringCollector.Entry>(this.entries.size());
        for (BestBucketsDeferringCollector.Entry sourceEntry : this.entries) {
            PackedLongValues.Builder newBuckets = PackedLongValues.packedBuilder((float)0.25f);
            PackedLongValues.Builder newDocDeltas = PackedLongValues.packedBuilder((float)0.25f);
            docDeltasItr = sourceEntry.docDeltas.iterator();
            lastGoodDelta = 0L;
            for (long bucket : sourceEntry.buckets) {
                assert (docDeltasItr.hasNext());
                delta = docDeltasItr.next();
                ordinal = mergeMap.applyAsLong(bucket);
                if (ordinal != -1L) {
                    newBuckets.add(ordinal);
                    newDocDeltas.add(delta + lastGoodDelta);
                    lastGoodDelta = 0L;
                    continue;
                }
                lastGoodDelta += delta;
            }
            if (newBuckets.size() <= 0L) continue;
            assert (newDocDeltas.size() > 0L) : "docDeltas was empty but we had buckets";
            newEntries.add(new BestBucketsDeferringCollector.Entry(sourceEntry.context, newDocDeltas.build(), newBuckets.build()));
        }
        this.entries = newEntries;
        if (this.bucketsBuilder != null && this.bucketsBuilder.size() > 0L) {
            PackedLongValues currentBuckets = this.bucketsBuilder.build();
            PackedLongValues.Builder newBuckets = PackedLongValues.packedBuilder((float)0.25f);
            PackedLongValues.Builder newDocDeltas = PackedLongValues.packedBuilder((float)0.25f);
            PackedLongValues currentDeltas = this.docDeltasBuilder.build();
            docDeltasItr = currentDeltas.iterator();
            lastGoodDelta = 0L;
            for (long bucket : currentBuckets) {
                assert (docDeltasItr.hasNext());
                delta = docDeltasItr.next();
                ordinal = mergeMap.applyAsLong(bucket);
                if (ordinal != -1L) {
                    newBuckets.add(ordinal);
                    newDocDeltas.add(delta + lastGoodDelta);
                    lastGoodDelta = 0L;
                    continue;
                }
                lastGoodDelta += delta;
            }
            this.docDeltasBuilder = newDocDeltas;
            this.bucketsBuilder = newBuckets;
        }
    }
}

