/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import java.util.Arrays;

class IntArrayList {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private int[] array;
    private int size;

    public IntArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(String.format("Initial capacity '%s' is negative", initialCapacity));
        }
        this.array = new int[initialCapacity];
    }

    public IntArrayList() {
        this(16);
    }

    public int[] elements() {
        return this.array;
    }

    private void grow(int newCapacity) {
        if (this.array.length == 0x7FFFFFF5) {
            throw new IllegalStateException("Array reached maximum size");
        }
        if (newCapacity > this.array.length) {
            int newLength = Math.clamp((long)this.array.length * 2L, newCapacity, 0x7FFFFFF5);
            this.array = Arrays.copyOf(this.array, newLength);
        }
    }

    public void add(int element) {
        this.grow(this.size + 1);
        this.array[this.size++] = element;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

